/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.io;

import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang.Converter;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.io.Decoder;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.io.Decoders;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.io.DecodingException;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.io.Encoder;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.io.Encoders;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.Assert;

public class Codec
implements Converter<byte[], CharSequence> {
    public static final Codec BASE64 = new Codec(Encoders.BASE64, Decoders.BASE64);
    public static final Codec BASE64URL = new Codec(Encoders.BASE64URL, Decoders.BASE64URL);
    private final Encoder<byte[], String> encoder;
    private final Decoder<CharSequence, byte[]> decoder;

    public Codec(Encoder<byte[], String> encoder, Decoder<CharSequence, byte[]> decoder) {
        this.encoder = Assert.notNull(encoder, "Encoder cannot be null.");
        this.decoder = Assert.notNull(decoder, "Decoder cannot be null.");
    }

    @Override
    public String applyTo(byte[] a) {
        return this.encoder.encode(a);
    }

    @Override
    public byte[] applyFrom(CharSequence b) {
        try {
            return this.decoder.decode(b);
        }
        catch (DecodingException e) {
            String msg = "Cannot decode input String. Cause: " + e.getMessage();
            throw new IllegalArgumentException(msg, e);
        }
    }
}

