/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.compression;

import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.compression.AbstractCompressionAlgorithm;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.Objects;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.InflaterOutputStream;

public class DeflateCompressionAlgorithm
extends AbstractCompressionAlgorithm {
    private static final String ID = "DEF";

    public DeflateCompressionAlgorithm() {
        super(ID);
    }

    @Override
    protected OutputStream doCompress(OutputStream out) {
        return new DeflaterOutputStream(out);
    }

    @Override
    protected InputStream doDecompress(InputStream is) {
        return new InflaterInputStream(is);
    }

    @Override
    protected byte[] doDecompress(byte[] compressed) throws IOException {
        try {
            return super.doDecompress(compressed);
        }
        catch (IOException e1) {
            try {
                return this.doDecompressBackCompat(compressed);
            }
            catch (IOException e2) {
                throw e1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] doDecompressBackCompat(byte[] compressed) throws IOException {
        byte[] byArray;
        InflaterOutputStream inflaterOutputStream = null;
        ByteArrayOutputStream decompressedOutputStream = null;
        try {
            decompressedOutputStream = new ByteArrayOutputStream();
            inflaterOutputStream = new InflaterOutputStream(decompressedOutputStream);
            inflaterOutputStream.write(compressed);
            inflaterOutputStream.flush();
            byArray = decompressedOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            Objects.nullSafeClose(decompressedOutputStream, inflaterOutputStream);
            throw throwable;
        }
        Objects.nullSafeClose(decompressedOutputStream, inflaterOutputStream);
        return byArray;
    }
}

