/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.io.jsonwebtoken.impl;

import com.salesforce.datacloud.shaded.io.jsonwebtoken.Claims;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.ClaimsMutator;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.Header;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.JweHeader;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.JwsHeader;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.JwtBuilder;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.Jwts;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.SignatureAlgorithm;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.DefaultClaims;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.DefaultHeader;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.DefaultJweHeader;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.DefaultJweHeaderBuilder;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.DefaultJwsHeader;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.DefaultJwtHeaderBuilder;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.DefaultMutableJweHeader;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.DefaultProtectedHeader;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.DelegateAudienceCollection;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.DelegatingClaimsMutator;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.ParameterMap;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.Payload;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.io.Base64UrlStreamEncoder;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.io.ByteBase64UrlStreamEncoder;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.io.CountingInputStream;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.io.EncodingOutputStream;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.io.NamedSerializer;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.io.Streams;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.io.UncloseableInputStream;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang.Bytes;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang.Function;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang.Functions;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang.Parameter;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.lang.Services;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.DefaultAeadRequest;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.DefaultAeadResult;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.DefaultKeyRequest;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.DefaultSecureRequest;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.Pbes2HsAkwAlgorithm;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.ProviderKey;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.impl.security.StandardSecureDigestAlgorithms;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.io.CompressionAlgorithm;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.io.Decoders;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.io.Encoder;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.io.Serializer;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.Assert;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.Collections;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.NestedCollection;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.Objects;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.Strings;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.AeadAlgorithm;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.AeadRequest;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.AeadResult;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.InvalidKeyException;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.KeyAlgorithm;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.KeyRequest;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.KeyResult;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.Password;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.SecureDigestAlgorithm;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.SecureRequest;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.SecurityException;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.SignatureException;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.security.UnsupportedKeyException;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.security.Key;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class DefaultJwtBuilder
implements JwtBuilder {
    private static final String PUB_KEY_SIGN_MSG = "PublicKeys may not be used to create digital signatures. PrivateKeys are used to sign, and PublicKeys are used to verify.";
    private static final String PRIV_KEY_ENC_MSG = "PrivateKeys may not be used to encrypt data. PublicKeys are used to encrypt, and PrivateKeys are used to decrypt.";
    protected Provider provider;
    protected SecureRandom secureRandom;
    private final DefaultBuilderHeader headerBuilder;
    private final DefaultBuilderClaims claimsBuilder;
    private Payload payload = Payload.EMPTY;
    private SecureDigestAlgorithm<Key, ?> sigAlg = Jwts.SIG.NONE;
    private Function<SecureRequest<InputStream, Key>, byte[]> signFunction;
    private AeadAlgorithm enc;
    private KeyAlgorithm<Key, ?> keyAlg;
    private Function<KeyRequest<Key>, KeyResult> keyAlgFunction;
    private Key key;
    private Serializer<Map<String, ?>> serializer;
    protected Encoder<OutputStream, OutputStream> encoder = Base64UrlStreamEncoder.INSTANCE;
    private boolean encodePayload = true;
    protected CompressionAlgorithm compressionAlgorithm;

    public DefaultJwtBuilder() {
        this.headerBuilder = new DefaultBuilderHeader(this);
        this.claimsBuilder = new DefaultBuilderClaims(this);
    }

    @Override
    public JwtBuilder.BuilderHeader header() {
        return this.headerBuilder;
    }

    @Override
    public JwtBuilder.BuilderClaims claims() {
        return this.claimsBuilder;
    }

    @Override
    public JwtBuilder provider(Provider provider) {
        this.provider = provider;
        return this;
    }

    @Override
    public JwtBuilder random(SecureRandom secureRandom) {
        this.secureRandom = secureRandom;
        return this;
    }

    @Override
    public JwtBuilder serializeToJsonWith(Serializer<Map<String, ?>> serializer) {
        return this.json(serializer);
    }

    @Override
    public JwtBuilder json(Serializer<Map<String, ?>> serializer) {
        this.serializer = Assert.notNull(serializer, "JSON Serializer cannot be null.");
        return this;
    }

    @Override
    public JwtBuilder base64UrlEncodeWith(Encoder<byte[], String> encoder) {
        return this.b64Url(new ByteBase64UrlStreamEncoder(encoder));
    }

    @Override
    public JwtBuilder b64Url(Encoder<OutputStream, OutputStream> encoder) {
        Assert.notNull(encoder, "encoder cannot be null.");
        this.encoder = encoder;
        return this;
    }

    @Override
    public JwtBuilder encodePayload(boolean b64) {
        this.encodePayload = b64;
        String critParamId = DefaultProtectedHeader.CRIT.getId();
        String b64Id = DefaultJwsHeader.B64.getId();
        LinkedHashSet crit = (LinkedHashSet)this.headerBuilder.get(DefaultProtectedHeader.CRIT);
        crit = new LinkedHashSet(Collections.nullSafe(crit));
        crit.remove(b64Id);
        return (JwtBuilder)((JwtBuilder.BuilderHeader)((JwtBuilder.BuilderHeader)this.header().delete(b64Id)).add(critParamId, crit)).and();
    }

    @Override
    public JwtBuilder setHeader(Map<String, ?> map) {
        return (JwtBuilder)((JwtBuilder.BuilderHeader)((JwtBuilder.BuilderHeader)this.header().empty()).add(map)).and();
    }

    @Override
    public JwtBuilder setHeaderParams(Map<String, ?> params) {
        return (JwtBuilder)((JwtBuilder.BuilderHeader)this.header().add(params)).and();
    }

    @Override
    public JwtBuilder setHeaderParam(String name, Object value) {
        return (JwtBuilder)((JwtBuilder.BuilderHeader)this.header().add(name, value)).and();
    }

    protected static <K extends Key> SecureDigestAlgorithm<K, ?> forSigningKey(K key) {
        Assert.notNull(key, "Key cannot be null.");
        SecureDigestAlgorithm<K, ?> alg = StandardSecureDigestAlgorithms.findBySigningKey(key);
        if (alg == null) {
            String msg = "Unable to determine a suitable MAC or Signature algorithm for the specified key using available heuristics: either the key size is too weak be used with available algorithms, or the key size is unavailable (e.g. if using a PKCS11 or HSM (Hardware Security Module) key store). If you are using a PKCS11 or HSM keystore, consider using the JwtBuilder.signWith(Key, SecureDigestAlgorithm) method instead.";
            throw new UnsupportedKeyException(msg);
        }
        return alg;
    }

    @Override
    public JwtBuilder signWith(Key key) throws InvalidKeyException {
        Assert.notNull(key, "Key argument cannot be null.");
        SecureDigestAlgorithm<Key, ?> alg = DefaultJwtBuilder.forSigningKey(key);
        return this.signWith(key, alg);
    }

    @Override
    public <K extends Key> JwtBuilder signWith(K key, SecureDigestAlgorithm<? super K, ?> alg) throws InvalidKeyException {
        Assert.notNull(key, "Key argument cannot be null.");
        if (key instanceof PublicKey) {
            throw new IllegalArgumentException(PUB_KEY_SIGN_MSG);
        }
        Assert.notNull(alg, "SignatureAlgorithm cannot be null.");
        String id = Assert.hasText(alg.getId(), "SignatureAlgorithm id cannot be null or empty.");
        if (Jwts.SIG.NONE.getId().equalsIgnoreCase(id)) {
            String msg = "The 'none' JWS algorithm cannot be used to sign JWTs.";
            throw new IllegalArgumentException(msg);
        }
        this.key = key;
        this.sigAlg = alg;
        this.signFunction = Functions.wrap(new Function<SecureRequest<InputStream, Key>, byte[]>(){

            @Override
            public byte[] apply(SecureRequest<InputStream, Key> request) {
                return DefaultJwtBuilder.this.sigAlg.digest(request);
            }
        }, SignatureException.class, "Unable to compute %s signature.", id);
        return this;
    }

    @Override
    public JwtBuilder signWith(Key key, SignatureAlgorithm alg) throws InvalidKeyException {
        Assert.notNull(alg, "SignatureAlgorithm cannot be null.");
        alg.assertValidSigningKey(key);
        return this.signWith(key, Jwts.SIG.get().forKey(alg.getValue()));
    }

    @Override
    public JwtBuilder signWith(SignatureAlgorithm alg, byte[] secretKeyBytes) throws InvalidKeyException {
        Assert.notNull(alg, "SignatureAlgorithm cannot be null.");
        Assert.notEmpty(secretKeyBytes, "secret key byte array cannot be null or empty.");
        Assert.isTrue(alg.isHmac(), "Key bytes may only be specified for HMAC signatures.  If using RSA or Elliptic Curve, use the signWith(SignatureAlgorithm, Key) method instead.");
        SecretKeySpec key = new SecretKeySpec(secretKeyBytes, alg.getJcaName());
        return this.signWith(key, alg);
    }

    @Override
    public JwtBuilder signWith(SignatureAlgorithm alg, String base64EncodedSecretKey) throws InvalidKeyException {
        Assert.hasText(base64EncodedSecretKey, "base64-encoded secret key cannot be null or empty.");
        Assert.isTrue(alg.isHmac(), "Base64-encoded key bytes may only be specified for HMAC signatures.  If using RSA or Elliptic Curve, use the signWith(SignatureAlgorithm, Key) method instead.");
        byte[] bytes = Decoders.BASE64.decode(base64EncodedSecretKey);
        return this.signWith(alg, bytes);
    }

    @Override
    public JwtBuilder signWith(SignatureAlgorithm alg, Key key) {
        return this.signWith(key, alg);
    }

    @Override
    public JwtBuilder encryptWith(SecretKey key, AeadAlgorithm enc) {
        if (key instanceof Password) {
            return this.encryptWith((Password)key, new Pbes2HsAkwAlgorithm(enc.getKeyBitLength()), enc);
        }
        return this.encryptWith(key, Jwts.KEY.DIRECT, enc);
    }

    @Override
    public <K extends Key> JwtBuilder encryptWith(K key, KeyAlgorithm<? super K, ?> keyAlg, AeadAlgorithm enc) {
        this.enc = Assert.notNull(enc, "Encryption algorithm cannot be null.");
        Assert.hasText(enc.getId(), "Encryption algorithm id cannot be null or empty.");
        Assert.notNull(key, "Encryption key cannot be null.");
        if (key instanceof PrivateKey) {
            throw new IllegalArgumentException(PRIV_KEY_ENC_MSG);
        }
        Assert.notNull(keyAlg, "KeyAlgorithm cannot be null.");
        String algId = Assert.hasText(keyAlg.getId(), "KeyAlgorithm id cannot be null or empty.");
        this.key = key;
        final KeyAlgorithm<Key, ?> alg = this.keyAlg = keyAlg;
        String cekMsg = "Unable to obtain content encryption key from key management algorithm '%s'.";
        this.keyAlgFunction = Functions.wrap(new Function<KeyRequest<Key>, KeyResult>(){

            @Override
            public KeyResult apply(KeyRequest<Key> request) {
                return alg.getEncryptionKey(request);
            }
        }, SecurityException.class, "Unable to obtain content encryption key from key management algorithm '%s'.", algId);
        return this;
    }

    @Override
    public JwtBuilder compressWith(CompressionAlgorithm alg) {
        Assert.notNull(alg, "CompressionAlgorithm cannot be null");
        Assert.hasText(alg.getId(), "CompressionAlgorithm id cannot be null or empty.");
        this.compressionAlgorithm = alg;
        return (JwtBuilder)((JwtBuilder.BuilderHeader)this.header().delete(DefaultHeader.COMPRESSION_ALGORITHM.getId())).and();
    }

    @Override
    public JwtBuilder setPayload(String payload) {
        return this.content(payload);
    }

    @Override
    public JwtBuilder content(String content) {
        if (Strings.hasText(content)) {
            this.payload = new Payload(content, null);
        }
        return this;
    }

    @Override
    public JwtBuilder content(byte[] content) {
        if (!Bytes.isEmpty(content)) {
            this.payload = new Payload(content, null);
        }
        return this;
    }

    @Override
    public JwtBuilder content(InputStream in) {
        if (in != null) {
            this.payload = new Payload(in, null);
        }
        return this;
    }

    @Override
    public JwtBuilder content(byte[] content, String cty) {
        Assert.notEmpty(content, "content byte array cannot be null or empty.");
        Assert.hasText(cty, "Content Type String cannot be null or empty.");
        this.payload = new Payload(content, cty);
        return (JwtBuilder)((JwtBuilder.BuilderHeader)this.header().delete(DefaultHeader.CONTENT_TYPE.getId())).and();
    }

    @Override
    public JwtBuilder content(String content, String cty) throws IllegalArgumentException {
        Assert.hasText(content, "Content string cannot be null or empty.");
        Assert.hasText(cty, "ContentType string cannot be null or empty.");
        this.payload = new Payload(content, cty);
        return (JwtBuilder)((JwtBuilder.BuilderHeader)this.header().delete(DefaultHeader.CONTENT_TYPE.getId())).and();
    }

    @Override
    public JwtBuilder content(InputStream in, String cty) throws IllegalArgumentException {
        Assert.notNull(in, "Payload InputStream cannot be null.");
        Assert.hasText(cty, "ContentType string cannot be null or empty.");
        this.payload = new Payload(in, cty);
        return (JwtBuilder)((JwtBuilder.BuilderHeader)this.header().delete(DefaultHeader.CONTENT_TYPE.getId())).and();
    }

    @Override
    public JwtBuilder setClaims(Map<String, ?> claims) {
        Assert.notNull(claims, "Claims map cannot be null.");
        return (JwtBuilder)((JwtBuilder.BuilderClaims)((JwtBuilder.BuilderClaims)this.claims().empty()).add(claims)).and();
    }

    @Override
    public JwtBuilder addClaims(Map<String, ?> claims) {
        return this.claims(claims);
    }

    @Override
    public JwtBuilder claims(Map<String, ?> claims) {
        return (JwtBuilder)((JwtBuilder.BuilderClaims)this.claims().add(claims)).and();
    }

    @Override
    public JwtBuilder claim(String name, Object value) {
        return (JwtBuilder)((JwtBuilder.BuilderClaims)this.claims().add(name, value)).and();
    }

    @Override
    public JwtBuilder setIssuer(String iss) {
        return this.issuer(iss);
    }

    @Override
    public JwtBuilder issuer(String iss) {
        return (JwtBuilder)((JwtBuilder.BuilderClaims)this.claims().issuer(iss)).and();
    }

    @Override
    public JwtBuilder setSubject(String sub) {
        return this.subject(sub);
    }

    @Override
    public JwtBuilder subject(String sub) {
        return (JwtBuilder)((JwtBuilder.BuilderClaims)this.claims().subject(sub)).and();
    }

    @Override
    public JwtBuilder setAudience(String aud) {
        return (JwtBuilder)((JwtBuilder.BuilderClaims)this.claims().setAudience(aud)).and();
    }

    @Override
    public ClaimsMutator.AudienceCollection<JwtBuilder> audience() {
        return new DelegateAudienceCollection<JwtBuilder>(this, this.claims().audience());
    }

    @Override
    public JwtBuilder setExpiration(Date exp) {
        return this.expiration(exp);
    }

    @Override
    public JwtBuilder expiration(Date exp) {
        return (JwtBuilder)((JwtBuilder.BuilderClaims)this.claims().expiration(exp)).and();
    }

    @Override
    public JwtBuilder setNotBefore(Date nbf) {
        return this.notBefore(nbf);
    }

    @Override
    public JwtBuilder notBefore(Date nbf) {
        return (JwtBuilder)((JwtBuilder.BuilderClaims)this.claims().notBefore(nbf)).and();
    }

    @Override
    public JwtBuilder setIssuedAt(Date iat) {
        return this.issuedAt(iat);
    }

    @Override
    public JwtBuilder issuedAt(Date iat) {
        return (JwtBuilder)((JwtBuilder.BuilderClaims)this.claims().issuedAt(iat)).and();
    }

    @Override
    public JwtBuilder setId(String jti) {
        return this.id(jti);
    }

    @Override
    public JwtBuilder id(String jti) {
        return (JwtBuilder)((JwtBuilder.BuilderClaims)this.claims().id(jti)).and();
    }

    private void assertPayloadEncoding(String type) {
        if (!this.encodePayload) {
            String msg = "Payload encoding may not be disabled for " + type + "s, only JWSs.";
            throw new IllegalArgumentException(msg);
        }
    }

    @Override
    public String compact() {
        boolean jwe;
        boolean bl = jwe = this.enc != null;
        if (jwe && this.signFunction != null) {
            String msg = "Both 'signWith' and 'encryptWith' cannot be specified. Choose either one.";
            throw new IllegalStateException(msg);
        }
        Payload payload = Assert.stateNotNull(this.payload, "Payload instance null, internal error");
        Claims claims = this.claimsBuilder.build();
        if (jwe && payload.isEmpty() && Collections.isEmpty(claims)) {
            String msg = "Encrypted JWTs must have either 'claims' or non-empty 'content'.";
            throw new IllegalStateException(msg);
        }
        if (!payload.isEmpty() && !Collections.isEmpty(claims)) {
            throw new IllegalStateException("Both 'content' and 'claims' cannot be specified. Choose either one.");
        }
        if (this.serializer == null) {
            this.json(Services.get(Serializer.class));
        }
        if (!Collections.isEmpty(claims)) {
            payload = new Payload(claims);
        }
        if (this.compressionAlgorithm != null && !payload.isEmpty()) {
            payload.setZip(this.compressionAlgorithm);
            this.headerBuilder.put(DefaultHeader.COMPRESSION_ALGORITHM.getId(), this.compressionAlgorithm.getId());
        }
        if (Strings.hasText(payload.getContentType())) {
            this.headerBuilder.contentType(payload.getContentType());
        }
        Provider keyProvider = ProviderKey.getProvider(this.key, this.provider);
        Key key = ProviderKey.getKey(this.key);
        if (jwe) {
            return this.encrypt(payload, key, keyProvider);
        }
        if (key != null) {
            return this.sign(payload, key, keyProvider);
        }
        return this.unprotected(payload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAndClose(String name, Map<String, ?> map, OutputStream out) {
        try {
            NamedSerializer named = new NamedSerializer(name, this.serializer);
            named.serialize(map, out);
        }
        catch (Throwable throwable) {
            Objects.nullSafeClose(out);
            throw throwable;
        }
        Objects.nullSafeClose(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeAndClose(String name, Payload payload, OutputStream out) {
        out = payload.compress(out);
        if (payload.isClaims()) {
            this.writeAndClose(name, payload.getRequiredClaims(), out);
            return;
        }
        try {
            InputStream in = payload.toInputStream();
            Streams.copy(in, out, new byte[4096], "Unable to copy payload.");
        }
        catch (Throwable throwable) {
            Objects.nullSafeClose(out);
            throw throwable;
        }
        Objects.nullSafeClose(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String sign(Payload payload, Key key, Provider provider) {
        byte[] signature;
        InputStream signingInput;
        Assert.stateNotNull(key, "Key is required.");
        Assert.stateNotNull(this.sigAlg, "SignatureAlgorithm is required.");
        Assert.stateNotNull(this.signFunction, "Signature Algorithm function cannot be null.");
        Assert.stateNotNull(payload, "Payload argument cannot be null.");
        ByteArrayOutputStream jws = new ByteArrayOutputStream(4096);
        this.headerBuilder.add(DefaultHeader.ALGORITHM.getId(), this.sigAlg.getId());
        if (!this.encodePayload) {
            String id = DefaultJwsHeader.B64.getId();
            ((JwtBuilder.BuilderHeader)((NestedCollection)this.headerBuilder.critical().add(id)).and()).add(id, false);
        }
        JwsHeader header = Assert.isInstanceOf(JwsHeader.class, this.headerBuilder.build());
        this.encodeAndWrite("JWS Protected Header", header, (OutputStream)jws);
        jws.write(46);
        InputStream payloadStream = null;
        if (this.encodePayload) {
            this.encodeAndWrite("JWS Payload", payload, (OutputStream)jws);
            signingInput = Streams.of(jws.toByteArray());
        } else {
            InputStream prefixStream = Streams.of(jws.toByteArray());
            payloadStream = this.toInputStream("JWS Unencoded Payload", payload);
            if (!payload.isClaims()) {
                payloadStream = new CountingInputStream(payloadStream);
            }
            if (payloadStream.markSupported()) {
                payloadStream.mark(0);
            }
            signingInput = new SequenceInputStream(prefixStream, new UncloseableInputStream(payloadStream));
        }
        try {
            DefaultSecureRequest<InputStream, Key> request = new DefaultSecureRequest<InputStream, Key>(signingInput, provider, this.secureRandom, key);
            signature = this.signFunction.apply(request);
            if (!this.encodePayload) {
                if (!payload.isCompressed() && (payload.isClaims() || payload.isString())) {
                    Streams.copy(payloadStream, jws, new byte[8192], "Unable to copy attached Payload InputStream.");
                }
                if (payloadStream instanceof CountingInputStream && ((CountingInputStream)payloadStream).getCount() <= 0L) {
                    String msg = "'b64' Unencoded payload option has been specified, but payload is empty.";
                    throw new IllegalStateException(msg);
                }
            }
        }
        finally {
            Streams.reset(payloadStream);
        }
        jws.write(46);
        this.encodeAndWrite("JWS Signature", signature, (OutputStream)jws);
        return Strings.utf8(jws.toByteArray());
    }

    private String unprotected(Payload content) {
        Assert.stateNotNull(content, "Content argument cannot be null.");
        this.assertPayloadEncoding("unprotected JWT");
        this.headerBuilder.add(DefaultHeader.ALGORITHM.getId(), Jwts.SIG.NONE.getId());
        ByteArrayOutputStream jwt = new ByteArrayOutputStream(512);
        Header header = this.headerBuilder.build();
        this.encodeAndWrite("JWT Header", header, (OutputStream)jwt);
        jwt.write(46);
        this.encodeAndWrite("JWT Payload", content, (OutputStream)jwt);
        jwt.write(46);
        return Strings.ascii(jwt.toByteArray());
    }

    private void encrypt(final AeadRequest req, final AeadResult res) throws SecurityException {
        Function<Object, Object> fn = Functions.wrap(new Function<Object, Object>(){

            @Override
            public Object apply(Object o) {
                DefaultJwtBuilder.this.enc.encrypt(req, res);
                return null;
            }
        }, SecurityException.class, "%s encryption failed.", this.enc.getId());
        fn.apply(null);
    }

    private String encrypt(Payload content, Key key, Provider keyProvider) {
        Assert.stateNotNull(content, "Payload argument cannot be null.");
        Assert.stateNotNull(key, "Key is required.");
        Assert.stateNotNull(this.enc, "Encryption algorithm is required.");
        Assert.stateNotNull(this.keyAlg, "KeyAlgorithm is required.");
        Assert.stateNotNull(this.keyAlgFunction, "KeyAlgorithm function cannot be null.");
        this.assertPayloadEncoding("JWE");
        InputStream plaintext = this.toInputStream("JWE Payload", content);
        DefaultMutableJweHeader delegate = new DefaultMutableJweHeader(this.headerBuilder);
        DefaultKeyRequest<Key> keyRequest = new DefaultKeyRequest<Key>(key, keyProvider, this.secureRandom, delegate, this.enc);
        KeyResult keyResult = this.keyAlgFunction.apply(keyRequest);
        Assert.stateNotNull(keyResult, "KeyAlgorithm must return a KeyResult.");
        SecretKey cek = (SecretKey)Assert.notNull(keyResult.getKey(), "KeyResult must return a content encryption key.");
        byte[] encryptedCek = (byte[])Assert.notNull(keyResult.getPayload(), "KeyResult must return an encrypted key byte array, even if empty.");
        this.headerBuilder.add(DefaultHeader.ALGORITHM.getId(), this.keyAlg.getId());
        this.headerBuilder.put(DefaultJweHeader.ENCRYPTION_ALGORITHM.getId(), this.enc.getId());
        JweHeader header = Assert.isInstanceOf(JweHeader.class, this.headerBuilder.build(), "Invalid header created: ");
        ByteArrayOutputStream jwe = new ByteArrayOutputStream(8192);
        this.encodeAndWrite("JWE Protected Header", header, (OutputStream)jwe);
        InputStream aad = Streams.of(jwe.toByteArray());
        ByteArrayOutputStream ciphertextOut = new ByteArrayOutputStream(8192);
        DefaultAeadRequest req = new DefaultAeadRequest(plaintext, null, this.secureRandom, cek, aad);
        DefaultAeadResult res = new DefaultAeadResult(ciphertextOut);
        this.encrypt(req, res);
        byte[] iv = Assert.notEmpty(res.getIv(), "Encryption result must have a non-empty initialization vector.");
        byte[] tag = Assert.notEmpty(res.getDigest(), "Encryption result must have a non-empty authentication tag.");
        byte[] ciphertext = Assert.notEmpty(ciphertextOut.toByteArray(), "Encryption result must have non-empty ciphertext.");
        jwe.write(46);
        this.encodeAndWrite("JWE Encrypted CEK", encryptedCek, (OutputStream)jwe);
        jwe.write(46);
        this.encodeAndWrite("JWE Initialization Vector", iv, (OutputStream)jwe);
        jwe.write(46);
        this.encodeAndWrite("JWE Ciphertext", ciphertext, (OutputStream)jwe);
        jwe.write(46);
        this.encodeAndWrite("JWE AAD Tag", tag, (OutputStream)jwe);
        return Strings.utf8(jwe.toByteArray());
    }

    private OutputStream encode(OutputStream out, String name) {
        out = this.encoder.encode(out);
        return new EncodingOutputStream(out, "base64url", name);
    }

    private void encodeAndWrite(String name, Map<String, ?> map, OutputStream out) {
        out = this.encode(out, name);
        this.writeAndClose(name, map, out);
    }

    private void encodeAndWrite(String name, Payload payload, OutputStream out) {
        out = this.encode(out, name);
        this.writeAndClose(name, payload, out);
    }

    private void encodeAndWrite(String name, byte[] data, OutputStream out) {
        out = this.encode(out, name);
        Streams.writeAndClose(out, data, "Unable to write bytes");
    }

    private InputStream toInputStream(String name, Payload payload) {
        if (payload.isClaims() || payload.isCompressed()) {
            ByteArrayOutputStream claimsOut = new ByteArrayOutputStream(8192);
            this.writeAndClose(name, payload, (OutputStream)claimsOut);
            return Streams.of(claimsOut.toByteArray());
        }
        return Assert.stateNotNull(payload.toInputStream(), "Payload InputStream cannot be null.");
    }

    private static class DefaultBuilderHeader
    extends DefaultJweHeaderBuilder<JwtBuilder.BuilderHeader>
    implements JwtBuilder.BuilderHeader {
        private final JwtBuilder builder;

        private DefaultBuilderHeader(JwtBuilder builder) {
            this.builder = Assert.notNull(builder, "JwtBuilder cannot be null.");
        }

        @Override
        public JwtBuilder and() {
            return this.builder;
        }

        private <T> T get(Parameter<T> param) {
            return ((ParameterMap)this.DELEGATE).get(param);
        }

        private Header build() {
            return new DefaultJwtHeaderBuilder(this).build();
        }
    }

    private static class DefaultBuilderClaims
    extends DelegatingClaimsMutator<JwtBuilder.BuilderClaims>
    implements JwtBuilder.BuilderClaims {
        private final JwtBuilder builder;

        private DefaultBuilderClaims(JwtBuilder builder) {
            this.builder = builder;
        }

        @Override
        public JwtBuilder and() {
            return this.builder;
        }

        private Claims build() {
            return new DefaultClaims((ParameterMap)this.DELEGATE);
        }
    }
}

