/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.io.jsonwebtoken;

import com.salesforce.datacloud.shaded.io.jsonwebtoken.Header;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.JweHeader;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.JwsHeader;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.Locator;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.ProtectedHeader;
import com.salesforce.datacloud.shaded.io.jsonwebtoken.lang.Assert;

public abstract class LocatorAdapter<T>
implements Locator<T> {
    @Override
    public final T locate(Header header) {
        Assert.notNull(header, "Header cannot be null.");
        if (header instanceof ProtectedHeader) {
            ProtectedHeader protectedHeader = (ProtectedHeader)header;
            return this.locate(protectedHeader);
        }
        return this.doLocate(header);
    }

    protected T locate(ProtectedHeader header) {
        if (header instanceof JwsHeader) {
            return this.locate((JwsHeader)header);
        }
        Assert.isInstanceOf(JweHeader.class, header, "Unrecognized ProtectedHeader type.");
        return this.locate((JweHeader)header);
    }

    protected T locate(JweHeader header) {
        return null;
    }

    protected T locate(JwsHeader header) {
        return null;
    }

    protected T doLocate(Header header) {
        return null;
    }
}

