/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.io.grpc;

import com.salesforce.datacloud.shaded.io.grpc.Configurator;
import com.salesforce.datacloud.shaded.io.grpc.ConfiguratorRegistry;
import com.salesforce.datacloud.shaded.io.grpc.Internal;
import com.salesforce.datacloud.shaded.io.grpc.InternalConfigurator;
import com.salesforce.datacloud.shaded.io.grpc.ManagedChannelBuilder;
import com.salesforce.datacloud.shaded.io.grpc.ServerBuilder;
import java.util.List;

@Internal
public final class InternalConfiguratorRegistry {
    private InternalConfiguratorRegistry() {
    }

    public static void setConfigurators(List<InternalConfigurator> configurators) {
        ConfiguratorRegistry.getDefaultRegistry().setConfigurators(configurators);
    }

    public static List<?> getConfigurators() {
        return ConfiguratorRegistry.getDefaultRegistry().getConfigurators();
    }

    public static void configureChannelBuilder(ManagedChannelBuilder<?> channelBuilder) {
        for (Configurator configurator : ConfiguratorRegistry.getDefaultRegistry().getConfigurators()) {
            configurator.configureChannelBuilder(channelBuilder);
        }
    }

    public static void configureServerBuilder(ServerBuilder<?> serverBuilder) {
        for (Configurator configurator : ConfiguratorRegistry.getDefaultRegistry().getConfigurators()) {
            configurator.configureServerBuilder(serverBuilder);
        }
    }

    public static boolean wasSetConfiguratorsCalled() {
        return ConfiguratorRegistry.getDefaultRegistry().wasSetConfiguratorsCalled();
    }
}

