/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.dev.failsafe.internal;

import com.salesforce.datacloud.shaded.dev.failsafe.ExecutionContext;
import com.salesforce.datacloud.shaded.dev.failsafe.Fallback;
import com.salesforce.datacloud.shaded.dev.failsafe.FallbackConfig;
import com.salesforce.datacloud.shaded.dev.failsafe.event.ExecutionAttemptedEvent;
import com.salesforce.datacloud.shaded.dev.failsafe.internal.FallbackExecutor;
import com.salesforce.datacloud.shaded.dev.failsafe.spi.FailurePolicy;
import com.salesforce.datacloud.shaded.dev.failsafe.spi.PolicyExecutor;
import java.util.concurrent.CompletableFuture;

public class FallbackImpl<R>
implements Fallback<R>,
FailurePolicy<R> {
    public static Fallback<Void> NONE = Fallback.builder(() -> null).build();
    private final FallbackConfig<R> config;

    public FallbackImpl(FallbackConfig<R> config) {
        this.config = config;
    }

    @Override
    public FallbackConfig<R> getConfig() {
        return this.config;
    }

    protected R apply(R result, Throwable exception, ExecutionContext<R> context) throws Throwable {
        ExecutionAttemptedEvent<R> event = new ExecutionAttemptedEvent<R>(result, exception, context);
        return this.config.getFallback() != null ? this.config.getFallback().apply(event) : this.config.getFallbackStage().apply(event).get();
    }

    protected CompletableFuture<R> applyStage(R result, Throwable exception, ExecutionContext<R> context) throws Throwable {
        ExecutionAttemptedEvent<R> event = new ExecutionAttemptedEvent<R>(result, exception, context);
        return this.config.getFallback() != null ? CompletableFuture.completedFuture(this.config.getFallback().apply(event)) : this.config.getFallbackStage().apply(event);
    }

    @Override
    public PolicyExecutor<R> toExecutor(int policyIndex) {
        return new FallbackExecutor(this, policyIndex);
    }
}

