/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.dev.failsafe;

import com.salesforce.datacloud.shaded.dev.failsafe.ExecutionContext;
import com.salesforce.datacloud.shaded.dev.failsafe.FailsafeException;
import com.salesforce.datacloud.shaded.dev.failsafe.SyncExecutionImpl;
import com.salesforce.datacloud.shaded.dev.failsafe.function.AsyncRunnable;
import com.salesforce.datacloud.shaded.dev.failsafe.function.CheckedConsumer;
import com.salesforce.datacloud.shaded.dev.failsafe.function.CheckedFunction;
import com.salesforce.datacloud.shaded.dev.failsafe.function.CheckedRunnable;
import com.salesforce.datacloud.shaded.dev.failsafe.function.CheckedSupplier;
import com.salesforce.datacloud.shaded.dev.failsafe.function.ContextualRunnable;
import com.salesforce.datacloud.shaded.dev.failsafe.function.ContextualSupplier;
import com.salesforce.datacloud.shaded.dev.failsafe.internal.util.Assert;
import com.salesforce.datacloud.shaded.dev.failsafe.spi.AsyncExecutionInternal;
import com.salesforce.datacloud.shaded.dev.failsafe.spi.ExecutionResult;
import com.salesforce.datacloud.shaded.dev.failsafe.spi.FailsafeFuture;
import com.salesforce.datacloud.shaded.dev.failsafe.spi.Scheduler;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;

final class Functions {
    Functions() {
    }

    static <R> Function<SyncExecutionImpl<R>, ExecutionResult<R>> get(ContextualSupplier<R, R> supplier, Executor executor) {
        return execution -> {
            ExecutionResult<Object> result;
            Throwable throwable = null;
            try {
                execution.preExecute();
                result = ExecutionResult.success(Functions.withExecutor(supplier, executor).get((ExecutionContext)execution));
            }
            catch (Throwable t2) {
                throwable = t2;
                result = ExecutionResult.exception(t2);
            }
            execution.record(result);
            Object object = execution.getLock();
            synchronized (object) {
                execution.setInterruptable(false);
                if (execution.isInterrupted()) {
                    Thread.interrupted();
                    return execution.getResult();
                }
                if (throwable instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            return result;
        };
    }

    static <R> Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>> getPromise(ContextualSupplier<R, R> supplier, Executor executor) {
        Assert.notNull(supplier, "supplier");
        return execution -> {
            ExecutionResult<Object> result;
            try {
                execution.preExecute();
                result = ExecutionResult.success(Functions.withExecutor(supplier, executor).get((ExecutionContext)execution));
            }
            catch (Throwable t2) {
                result = ExecutionResult.exception(t2);
            }
            execution.record(result);
            return CompletableFuture.completedFuture(result);
        };
    }

    static <R> Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>> getPromiseExecution(final AsyncRunnable<R> runnable2, final Executor executor) {
        Assert.notNull(runnable2, "runnable");
        return new Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>>(){

            @Override
            public synchronized CompletableFuture<ExecutionResult<R>> apply(AsyncExecutionInternal<R> execution) {
                try {
                    execution.preExecute();
                    Functions.withExecutor(runnable2, executor).run(execution);
                }
                catch (Throwable e) {
                    execution.record(null, e);
                }
                return ExecutionResult.nullFuture();
            }
        };
    }

    static <R> Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>> getPromiseOfStage(ContextualSupplier<R, ? extends CompletionStage<? extends R>> supplier, FailsafeFuture<R> future, Executor executor) {
        Assert.notNull(supplier, "supplier");
        return execution -> {
            CompletableFuture promise = new CompletableFuture();
            try {
                execution.preExecute();
                CompletionStage stage = (CompletionStage)Functions.withExecutor(supplier, executor).get((ExecutionContext)execution);
                if (stage == null) {
                    ExecutionResult<Object> r = ExecutionResult.success(null);
                    execution.record(r);
                    promise.complete(r);
                } else {
                    if (stage instanceof Future) {
                        future.propagateCancellation((Future)((Object)stage));
                    }
                    stage.whenComplete((result, exception) -> {
                        if (exception instanceof CompletionException) {
                            exception = exception.getCause();
                        }
                        ExecutionResult<Object> r = exception == null ? ExecutionResult.success(result) : ExecutionResult.exception(exception);
                        execution.record(r);
                        promise.complete(r);
                    });
                }
            }
            catch (Throwable t2) {
                ExecutionResult result2 = ExecutionResult.exception(t2);
                execution.record(result2);
                promise.complete(result2);
            }
            return promise;
        };
    }

    static <R> Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>> toExecutionAware(Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>> innerFn) {
        return execution -> {
            ExecutionResult result = execution.getResult();
            if (result == null) {
                return (CompletableFuture)innerFn.apply((AsyncExecutionInternal)execution);
            }
            return CompletableFuture.completedFuture(result);
        };
    }

    static <R> Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>> toAsync(Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>> innerFn, Scheduler scheduler, FailsafeFuture<R> future) {
        AtomicBoolean scheduled = new AtomicBoolean();
        return execution -> {
            if (scheduled.get()) {
                return (CompletableFuture)innerFn.apply((AsyncExecutionInternal)execution);
            }
            CompletableFuture promise = new CompletableFuture();
            Callable<Object> callable = () -> ((CompletableFuture)innerFn.apply((AsyncExecutionInternal)execution)).whenComplete((result, error) -> {
                if (error != null) {
                    promise.completeExceptionally((Throwable)error);
                } else {
                    promise.complete(result);
                }
            });
            try {
                scheduled.set(true);
                ScheduledFuture<?> scheduledFuture = scheduler.schedule(callable, 0L, TimeUnit.NANOSECONDS);
                future.setCancelFn(-1, (mayInterrupt, cancelResult) -> {
                    scheduledFuture.cancel((boolean)mayInterrupt);
                    if (!execution.isPreExecuted()) {
                        promise.complete(cancelResult);
                    }
                });
            }
            catch (Throwable t2) {
                promise.completeExceptionally(t2);
            }
            return promise;
        };
    }

    static ContextualSupplier<Void, Void> toCtxSupplier(CheckedRunnable runnable2) {
        Assert.notNull(runnable2, "runnable");
        return ctx -> {
            runnable2.run();
            return null;
        };
    }

    static ContextualSupplier<Void, Void> toCtxSupplier(ContextualRunnable<Void> runnable2) {
        Assert.notNull(runnable2, "runnable");
        return ctx -> {
            runnable2.run(ctx);
            return null;
        };
    }

    static <R, T> ContextualSupplier<R, T> toCtxSupplier(CheckedSupplier<T> supplier) {
        Assert.notNull(supplier, "supplier");
        return ctx -> supplier.get();
    }

    static <R, T> ContextualSupplier<R, T> withExecutor(ContextualSupplier<R, T> supplier, Executor executor) {
        return executor == null ? supplier : ctx -> {
            executor.execute(() -> {
                try {
                    supplier.get(ctx);
                }
                catch (Throwable e) {
                    Functions.handleExecutorThrowable(e);
                }
            });
            return null;
        };
    }

    static <R> AsyncRunnable<R> withExecutor(AsyncRunnable<R> runnable2, Executor executor) {
        return executor == null ? runnable2 : exec -> executor.execute(() -> {
            try {
                runnable2.run(exec);
            }
            catch (Throwable e) {
                Functions.handleExecutorThrowable(e);
            }
        });
    }

    private static void handleExecutorThrowable(Throwable e) {
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
        throw new FailsafeException(e);
    }

    static <T, R> CheckedFunction<T, R> toFn(CheckedConsumer<T> consumer) {
        return t2 -> {
            consumer.accept(t2);
            return null;
        };
    }

    static <T, R> CheckedFunction<T, R> toFn(CheckedRunnable runnable2) {
        return t2 -> {
            runnable2.run();
            return null;
        };
    }

    static <T, R> CheckedFunction<T, R> toFn(CheckedSupplier<? extends R> supplier) {
        return t2 -> supplier.get();
    }

    static <T, R> CheckedFunction<T, R> toFn(R result) {
        return t2 -> result;
    }
}

