/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.dev.failsafe;

import com.salesforce.datacloud.shaded.dev.failsafe.FallbackBuilder;
import com.salesforce.datacloud.shaded.dev.failsafe.FallbackConfig;
import com.salesforce.datacloud.shaded.dev.failsafe.Functions;
import com.salesforce.datacloud.shaded.dev.failsafe.Policy;
import com.salesforce.datacloud.shaded.dev.failsafe.event.ExecutionAttemptedEvent;
import com.salesforce.datacloud.shaded.dev.failsafe.function.CheckedConsumer;
import com.salesforce.datacloud.shaded.dev.failsafe.function.CheckedFunction;
import com.salesforce.datacloud.shaded.dev.failsafe.function.CheckedRunnable;
import com.salesforce.datacloud.shaded.dev.failsafe.function.CheckedSupplier;
import com.salesforce.datacloud.shaded.dev.failsafe.internal.FallbackImpl;
import com.salesforce.datacloud.shaded.dev.failsafe.internal.util.Assert;
import java.util.concurrent.CompletionStage;

public interface Fallback<R>
extends Policy<R> {
    public static <R> FallbackBuilder<R> builder(FallbackConfig<R> config) {
        return new FallbackBuilder<R>(config);
    }

    public static <R> FallbackBuilder<R> builder(CheckedRunnable fallback) {
        return new FallbackBuilder<CheckedRunnable>(Functions.toFn(Assert.notNull(fallback, "fallback")), null);
    }

    public static <R> FallbackBuilder<R> builder(CheckedSupplier<? extends R> fallback) {
        return new FallbackBuilder<CheckedSupplier<? extends R>>(Functions.toFn(Assert.notNull(fallback, "fallback")), null);
    }

    public static <R> FallbackBuilder<R> builder(CheckedConsumer<ExecutionAttemptedEvent<? extends R>> fallback) {
        return new FallbackBuilder<CheckedConsumer<ExecutionAttemptedEvent<? extends R>>>(Functions.toFn(Assert.notNull(fallback, "fallback")), null);
    }

    public static <R> FallbackBuilder<R> builder(CheckedFunction<ExecutionAttemptedEvent<? extends R>, ? extends R> fallback) {
        return new FallbackBuilder<R>(Assert.notNull(fallback, "fallback"), null);
    }

    public static <R> FallbackBuilder<R> builder(R fallbackResult) {
        return new FallbackBuilder<R>(Functions.toFn(fallbackResult), null);
    }

    public static <R> FallbackBuilder<R> builderOfException(CheckedFunction<ExecutionAttemptedEvent<? extends R>, ? extends Exception> fallback) {
        Assert.notNull(fallback, "fallback");
        return new FallbackBuilder<Object>(e -> {
            throw (Exception)fallback.apply((ExecutionAttemptedEvent)e);
        }, null);
    }

    public static <R> FallbackBuilder<R> builderOfStage(CheckedSupplier<? extends CompletionStage<R>> fallback) {
        return new FallbackBuilder<CompletionStage<R>>(null, Functions.toFn(Assert.notNull(fallback, "fallback")));
    }

    public static <R> FallbackBuilder<R> builderOfStage(CheckedFunction<ExecutionAttemptedEvent<? extends R>, ? extends CompletionStage<R>> fallback) {
        return new FallbackBuilder<R>(null, Assert.notNull(fallback, "fallback"));
    }

    public static <R> Fallback<R> of(CheckedRunnable fallback) {
        return new FallbackImpl<CheckedRunnable>(new FallbackConfig<CheckedRunnable>(Functions.toFn(Assert.notNull(fallback, "fallback")), null));
    }

    public static <R> Fallback<R> of(CheckedSupplier<? extends R> fallback) {
        return new FallbackImpl<CheckedSupplier<? extends R>>(new FallbackConfig<CheckedSupplier<? extends R>>(Functions.toFn(Assert.notNull(fallback, "fallback")), null));
    }

    public static <R> Fallback<R> of(CheckedConsumer<ExecutionAttemptedEvent<? extends R>> fallback) {
        return new FallbackImpl<CheckedConsumer<ExecutionAttemptedEvent<? extends R>>>(new FallbackConfig<CheckedConsumer<ExecutionAttemptedEvent<? extends R>>>(Functions.toFn(Assert.notNull(fallback, "fallback")), null));
    }

    public static <R> Fallback<R> of(CheckedFunction<ExecutionAttemptedEvent<? extends R>, ? extends R> fallback) {
        return new FallbackImpl<R>(new FallbackConfig<R>(Assert.notNull(fallback, "fallback"), null));
    }

    public static <R> Fallback<R> ofException(CheckedFunction<ExecutionAttemptedEvent<? extends R>, ? extends Exception> fallback) {
        Assert.notNull(fallback, "fallback");
        return new FallbackImpl<Object>(new FallbackConfig<Object>(e -> {
            throw (Exception)fallback.apply((ExecutionAttemptedEvent)e);
        }, null));
    }

    public static <R> Fallback<R> of(R fallbackResult) {
        return new FallbackImpl<R>(new FallbackConfig<R>(Functions.toFn(fallbackResult), null));
    }

    public static <R> Fallback<R> ofStage(CheckedSupplier<? extends CompletionStage<R>> fallback) {
        return new FallbackImpl<CompletionStage<R>>(new FallbackConfig<CompletionStage<R>>(null, Functions.toFn(Assert.notNull(fallback, "fallback"))));
    }

    public static <R> Fallback<R> ofStage(CheckedFunction<ExecutionAttemptedEvent<? extends R>, ? extends CompletionStage<R>> fallback) {
        return new FallbackImpl<R>(new FallbackConfig<R>(null, Assert.notNull(fallback, "fallback")));
    }

    public static Fallback<Void> none() {
        return FallbackImpl.NONE;
    }

    @Override
    public FallbackConfig<R> getConfig();
}

