/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.dev.failsafe;

import com.salesforce.datacloud.shaded.dev.failsafe.FailurePolicyConfig;
import com.salesforce.datacloud.shaded.dev.failsafe.PolicyBuilder;
import com.salesforce.datacloud.shaded.dev.failsafe.function.CheckedBiPredicate;
import com.salesforce.datacloud.shaded.dev.failsafe.function.CheckedPredicate;
import com.salesforce.datacloud.shaded.dev.failsafe.internal.util.Assert;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public abstract class FailurePolicyBuilder<S, C extends FailurePolicyConfig<R>, R>
extends PolicyBuilder<S, C, R> {
    protected FailurePolicyBuilder(C config) {
        super(config);
    }

    public S handle(Class<? extends Throwable> exception) {
        Assert.notNull(exception, "exception");
        return this.handle(Arrays.asList(exception));
    }

    @SafeVarargs
    public final S handle(Class<? extends Throwable> ... exceptions) {
        Assert.notNull(exceptions, "exceptions");
        Assert.isTrue(exceptions.length > 0, "exceptions cannot be empty", new Object[0]);
        return this.handle(Arrays.asList(exceptions));
    }

    public S handle(List<Class<? extends Throwable>> exceptions) {
        Assert.notNull(exceptions, "exceptions");
        Assert.isTrue(!exceptions.isEmpty(), "exceptions cannot be empty", new Object[0]);
        ((FailurePolicyConfig)this.config).exceptionsChecked = true;
        ((FailurePolicyConfig)this.config).failureConditions.add(FailurePolicyBuilder.failurePredicateFor(exceptions));
        return (S)this;
    }

    public S handleIf(CheckedPredicate<? extends Throwable> failurePredicate) {
        Assert.notNull(failurePredicate, "failurePredicate");
        ((FailurePolicyConfig)this.config).exceptionsChecked = true;
        ((FailurePolicyConfig)this.config).failureConditions.add(FailurePolicyBuilder.failurePredicateFor(failurePredicate));
        return (S)this;
    }

    public S handleIf(CheckedBiPredicate<R, ? extends Throwable> resultPredicate) {
        Assert.notNull(resultPredicate, "resultPredicate");
        ((FailurePolicyConfig)this.config).exceptionsChecked = true;
        ((FailurePolicyConfig)this.config).failureConditions.add(resultPredicate);
        return (S)this;
    }

    public S handleResult(R result) {
        ((FailurePolicyConfig)this.config).failureConditions.add(FailurePolicyBuilder.resultPredicateFor(result));
        return (S)this;
    }

    public S handleResultIf(CheckedPredicate<R> resultPredicate) {
        Assert.notNull(resultPredicate, "resultPredicate");
        ((FailurePolicyConfig)this.config).failureConditions.add(FailurePolicyBuilder.resultPredicateFor(resultPredicate));
        return (S)this;
    }

    static <R> CheckedBiPredicate<R, Throwable> resultPredicateFor(R result) {
        return (t2, u) -> result == null ? t2 == null && u == null : Objects.equals(result, t2);
    }

    static <R> CheckedBiPredicate<R, Throwable> failurePredicateFor(CheckedPredicate<? extends Throwable> failurePredicate) {
        return (t2, u) -> u != null && failurePredicate.test((Throwable)u);
    }

    static <R> CheckedBiPredicate<R, Throwable> resultPredicateFor(CheckedPredicate<R> resultPredicate) {
        return (t2, u) -> {
            if (u == null) {
                return resultPredicate.test(t2);
            }
            return false;
        };
    }

    static <R> CheckedBiPredicate<R, Throwable> failurePredicateFor(List<Class<? extends Throwable>> failures) {
        return (t2, u) -> {
            if (u == null) {
                return false;
            }
            for (Class failureType : failures) {
                if (!failureType.isAssignableFrom(u.getClass())) continue;
                return true;
            }
            return false;
        };
    }
}

