/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.dev.failsafe;

import com.salesforce.datacloud.shaded.dev.failsafe.DelayablePolicyConfig;
import com.salesforce.datacloud.shaded.dev.failsafe.FailurePolicyBuilder;
import com.salesforce.datacloud.shaded.dev.failsafe.function.ContextualSupplier;
import com.salesforce.datacloud.shaded.dev.failsafe.internal.util.Assert;
import java.time.Duration;

public abstract class DelayablePolicyBuilder<S, C extends DelayablePolicyConfig<R>, R>
extends FailurePolicyBuilder<S, C, R> {
    protected DelayablePolicyBuilder(C config) {
        super(config);
    }

    public S withDelay(Duration delay) {
        Assert.notNull(delay, "delay");
        Assert.isTrue(delay.toNanos() > 0L, "delay must be greater than 0", new Object[0]);
        ((DelayablePolicyConfig)this.config).delay = delay;
        return (S)this;
    }

    public S withDelayFn(ContextualSupplier<R, Duration> delayFunction) {
        Assert.notNull(delayFunction, "delayFunction");
        ((DelayablePolicyConfig)this.config).delayFn = delayFunction;
        return (S)this;
    }

    public <F extends Throwable> S withDelayFnOn(ContextualSupplier<R, Duration> delayFunction, Class<F> exception) {
        this.withDelayFn(delayFunction);
        Assert.notNull(exception, "exception");
        ((DelayablePolicyConfig)this.config).delayException = exception;
        return (S)this;
    }

    public S withDelayFnWhen(ContextualSupplier<R, Duration> delayFunction, R result) {
        this.withDelayFn(delayFunction);
        Assert.notNull(result, "result");
        ((DelayablePolicyConfig)this.config).delayResult = result;
        return (S)this;
    }
}

