/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.shaded.dev.failsafe;

import com.salesforce.datacloud.shaded.dev.failsafe.BulkheadBuilder;
import com.salesforce.datacloud.shaded.dev.failsafe.BulkheadConfig;
import com.salesforce.datacloud.shaded.dev.failsafe.BulkheadFullException;
import com.salesforce.datacloud.shaded.dev.failsafe.Policy;
import com.salesforce.datacloud.shaded.dev.failsafe.internal.BulkheadImpl;
import java.time.Duration;

public interface Bulkhead<R>
extends Policy<R> {
    public static <R> BulkheadBuilder<R> builder(int maxConcurrency) {
        return new BulkheadBuilder(maxConcurrency);
    }

    public static <R> BulkheadBuilder<R> builder(BulkheadConfig<R> config) {
        return new BulkheadBuilder<R>(config);
    }

    public static <R> Bulkhead<R> of(int maxConcurrency) {
        return new BulkheadImpl(new BulkheadConfig(maxConcurrency));
    }

    @Override
    public BulkheadConfig<R> getConfig();

    public void acquirePermit() throws InterruptedException;

    default public void acquirePermit(Duration maxWaitTime) throws InterruptedException {
        if (!this.tryAcquirePermit(maxWaitTime)) {
            throw new BulkheadFullException(this);
        }
    }

    public boolean tryAcquirePermit();

    public boolean tryAcquirePermit(Duration var1) throws InterruptedException;

    public void releasePermit();
}

