/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.util;

import com.salesforce.datacloud.jdbc.util.BaseVectorSetter;
import com.salesforce.datacloud.jdbc.util.DateTimeUtils;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.TimeMicroVector;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.TimeZone;

class TimeMicroVectorSetter
extends BaseVectorSetter<TimeMicroVector, Time> {
    private final Calendar calendar;

    TimeMicroVectorSetter(Calendar calendar) {
        super(Time.class);
        this.calendar = calendar;
    }

    @Override
    protected void setValueInternal(TimeMicroVector vector, Time value) {
        LocalDateTime localDateTime = new Timestamp(value.getTime()).toLocalDateTime();
        localDateTime = DateTimeUtils.adjustForCalendar(localDateTime, this.calendar, TimeZone.getTimeZone("UTC"));
        long midnightMillis = localDateTime.toLocalTime().toNanoOfDay() / 1000000L;
        long microsecondsSinceMidnight = DateTimeUtils.millisToMicrosecondsSinceMidnight(midnightMillis);
        vector.setSafe(0, microsecondsSinceMidnight);
    }

    @Override
    protected void setNullValue(TimeMicroVector vector) {
        vector.setNull(0);
    }
}

