/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.util;

import com.salesforce.datacloud.jdbc.util.ThrowingSupplier;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

public abstract class Result<T> {
    private Result() {
    }

    public static <T, E extends Exception> Result<T> of(@NonNull ThrowingSupplier<T, E> supplier) {
        if (supplier == null) {
            throw new IllegalArgumentException("supplier is marked non-null but is null");
        }
        try {
            return new Success<T>(supplier.get());
        }
        catch (Throwable t2) {
            return new Failure(t2);
        }
    }

    abstract Optional<T> get();

    abstract Optional<Throwable> getError();

    public static class Failure<T>
    extends Result<T> {
        private final Throwable error;

        @Override
        Optional<T> get() {
            return Optional.empty();
        }

        @Override
        Optional<Throwable> getError() {
            return Optional.ofNullable(this.error);
        }

        @Generated
        public Failure(Throwable error) {
            this.error = error;
        }
    }

    public static class Success<T>
    extends Result<T> {
        private final T value;

        @Override
        Optional<T> get() {
            return Optional.ofNullable(this.value);
        }

        @Override
        Optional<Throwable> getError() {
            return Optional.empty();
        }

        @Generated
        public T getValue() {
            return this.value;
        }

        @Generated
        public Success(T value) {
            this.value = value;
        }
    }
}

