/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.util;

import com.salesforce.datacloud.jdbc.core.DataCloudConnection;
import com.salesforce.datacloud.jdbc.core.DataCloudConnectionString;
import com.salesforce.datacloud.jdbc.exception.DataCloudJDBCException;
import com.salesforce.datacloud.jdbc.util.PropertiesExtensions;
import com.salesforce.datacloud.shaded.io.grpc.ManagedChannelBuilder;
import java.net.URI;
import java.sql.SQLException;
import java.util.Properties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DirectDataCloudConnection {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DirectDataCloudConnection.class);
    public static final String DIRECT = "direct";

    public static boolean isDirect(Properties properties) {
        return PropertiesExtensions.getBooleanOrDefault(properties, DIRECT, false);
    }

    public static DataCloudConnection of(String url, Properties properties) throws SQLException {
        boolean direct = PropertiesExtensions.getBooleanOrDefault(properties, DIRECT, false);
        if (!direct) {
            throw new DataCloudJDBCException("Cannot establish direct connection without direct enabled");
        }
        DataCloudConnectionString connString = DataCloudConnectionString.of(url);
        URI uri = URI.create(connString.getLoginUrl());
        log.info("Creating data cloud connection {}", (Object)uri);
        Object builder = ManagedChannelBuilder.forAddress(uri.getHost(), uri.getPort()).usePlaintext();
        return DataCloudConnection.of(builder, properties);
    }

    @Generated
    private DirectDataCloudConnection() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

