/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.interceptor;

import com.salesforce.datacloud.jdbc.interceptor.HeaderMutatingClientInterceptor;
import com.salesforce.datacloud.jdbc.interceptor.MetadataUtilities;
import com.salesforce.datacloud.shaded.io.grpc.Metadata;
import java.sql.SQLException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationHeaderInterceptor
implements HeaderMutatingClientInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthorizationHeaderInterceptor.class);
    private static final String AUTH = "Authorization";
    private static final String AUD = "audience";
    private static final Metadata.Key<String> AUTH_KEY = MetadataUtilities.keyOf("Authorization");
    private static final Metadata.Key<String> AUD_KEY = MetadataUtilities.keyOf("audience");
    private final TokenSupplier tokenSupplier;
    private final String name;

    public static AuthorizationHeaderInterceptor of(TokenSupplier supplier) {
        return new AuthorizationHeaderInterceptor(supplier, "custom");
    }

    @Override
    public void mutate(Metadata headers) {
        String token = this.tokenSupplier.getToken();
        headers.put(AUTH_KEY, token);
        String audience = this.tokenSupplier.getAudience();
        if (audience != null) {
            headers.put(AUD_KEY, audience);
        }
    }

    @Generated
    public String toString() {
        return "AuthorizationHeaderInterceptor(name=" + this.name + ")";
    }

    @Generated
    AuthorizationHeaderInterceptor(TokenSupplier tokenSupplier, String name) {
        this.tokenSupplier = tokenSupplier;
        this.name = name;
    }

    @FunctionalInterface
    public static interface TokenSupplier {
        public String getToken() throws SQLException;

        default public String getAudience() {
            return null;
        }
    }
}

