/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.http;

import com.salesforce.datacloud.jdbc.http.HttpClientLogger;
import com.salesforce.datacloud.jdbc.http.MetadataCacheInterceptor;
import com.salesforce.datacloud.jdbc.http.internal.SFDefaultSocketFactoryWrapper;
import com.salesforce.datacloud.jdbc.util.PropertiesExtensions;
import com.salesforce.datacloud.shaded.okhttp3.OkHttpClient;
import com.salesforce.datacloud.shaded.okhttp3.logging.HttpLoggingInterceptor;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClientBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClientBuilder.class);
    static final String LOG_LEVEL = "okhttp.logging.level";
    static final HttpLoggingInterceptor.Level DEFAULT_LOG_LEVEL = HttpLoggingInterceptor.Level.BASIC;
    static final String READ_TIME_OUT_SECONDS_KEY = "readTimeOutSeconds";
    static final int DEFAULT_READ_TIME_OUT_SECONDS = 600;
    static final String CONNECT_TIME_OUT_SECONDS_KEY = "connectTimeOutSeconds";
    static final int DEFAULT_CONNECT_TIME_OUT_SECONDS = 600;
    static final String CALL_TIME_OUT_SECONDS_KEY = "callTimeOutSeconds";
    static final int DEFAULT_CALL_TIME_OUT_SECONDS = 600;
    static final String DISABLE_SOCKS_PROXY_KEY = "disableSocksProxy";
    static final Boolean DISABLE_SOCKS_PROXY_DEFAULT = false;

    public static OkHttpClient buildOkHttpClient(Properties properties) {
        Boolean disableSocksProxy = PropertiesExtensions.optional(properties, DISABLE_SOCKS_PROXY_KEY).map(Boolean::valueOf).orElse(DISABLE_SOCKS_PROXY_DEFAULT);
        Integer readTimeout = PropertiesExtensions.getIntegerOrDefault(properties, READ_TIME_OUT_SECONDS_KEY, 600);
        Integer connectTimeout = PropertiesExtensions.getIntegerOrDefault(properties, CONNECT_TIME_OUT_SECONDS_KEY, 600);
        Integer callTimeout = PropertiesExtensions.getIntegerOrDefault(properties, CALL_TIME_OUT_SECONDS_KEY, 600);
        HttpLoggingInterceptor.Level level = PropertiesExtensions.getEnumOrDefault(properties, LOG_LEVEL, DEFAULT_LOG_LEVEL);
        HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor(new HttpClientLogger());
        loggingInterceptor.setLevel(level);
        return new OkHttpClient.Builder().socketFactory(new SFDefaultSocketFactoryWrapper(disableSocksProxy)).callTimeout(callTimeout.intValue(), TimeUnit.SECONDS).connectTimeout(connectTimeout.intValue(), TimeUnit.SECONDS).readTimeout(readTimeout.intValue(), TimeUnit.SECONDS).addInterceptor(new MetadataCacheInterceptor(properties)).addInterceptor(loggingInterceptor).build();
    }

    @Generated
    private ClientBuilder() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

