/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.core.partial;

import com.salesforce.datacloud.jdbc.core.HyperGrpcClientExecutor;
import com.salesforce.datacloud.jdbc.core.partial.RowBasedContext;
import com.salesforce.datacloud.jdbc.core.partial.RowBasedFullRange;
import com.salesforce.datacloud.jdbc.core.partial.RowBasedSingleRpc;
import com.salesforce.datacloud.jdbc.exception.DataCloudJDBCException;
import java.util.Iterator;
import lombok.NonNull;
import salesforce.cdp.hyperdb.v1.QueryResult;

public interface RowBased
extends Iterator<QueryResult> {
    public static RowBased of(@NonNull HyperGrpcClientExecutor client, @NonNull String queryId, long offset, long limit, @NonNull Mode mode) throws DataCloudJDBCException {
        if (client == null) {
            throw new IllegalArgumentException("client is marked non-null but is null");
        }
        if (queryId == null) {
            throw new IllegalArgumentException("queryId is marked non-null but is null");
        }
        if (mode == null) {
            throw new IllegalArgumentException("mode is marked non-null but is null");
        }
        RowBasedContext context = RowBasedContext.builder().client(client).queryId(queryId).offset(offset).limit(limit).build();
        switch (mode) {
            case SINGLE_RPC: {
                return RowBasedSingleRpc.builder().iterator(context.getQueryResult(false)).build();
            }
            case FULL_RANGE: {
                return RowBasedFullRange.builder().context(context).build();
            }
        }
        throw new IllegalArgumentException("Unknown mode not supported. mode=" + (Object)((Object)mode));
    }

    public static enum Mode {
        SINGLE_RPC,
        FULL_RANGE;

    }
}

