/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.core.partial;

import com.salesforce.datacloud.jdbc.core.HyperGrpcClientExecutor;
import com.salesforce.datacloud.jdbc.util.Unstable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import salesforce.cdp.hyperdb.v1.QueryResult;

@Unstable
public class ChunkBased
implements Iterator<QueryResult> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ChunkBased.class);
    @NonNull
    private final HyperGrpcClientExecutor client;
    @NonNull
    private final String queryId;
    private final AtomicLong chunkId;
    private final long limitId;
    private Iterator<QueryResult> iterator;
    private final AtomicBoolean omitSchema;

    public static ChunkBased of(@NonNull HyperGrpcClientExecutor client, @NonNull String queryId, long chunkId, long limit) {
        if (client == null) {
            throw new IllegalArgumentException("client is marked non-null but is null");
        }
        if (queryId == null) {
            throw new IllegalArgumentException("queryId is marked non-null but is null");
        }
        return ChunkBased.of(client, queryId, chunkId, limit, false);
    }

    public static ChunkBased of(@NonNull HyperGrpcClientExecutor client, @NonNull String queryId, long chunkId, long limit, boolean omitSchema) {
        if (client == null) {
            throw new IllegalArgumentException("client is marked non-null but is null");
        }
        if (queryId == null) {
            throw new IllegalArgumentException("queryId is marked non-null but is null");
        }
        return new ChunkBased(client, queryId, new AtomicLong(chunkId), chunkId + limit, new AtomicBoolean(omitSchema));
    }

    @Override
    public boolean hasNext() {
        if (this.iterator == null) {
            log.info("Fetching chunk based query result stream. queryId={}, chunkId={}, limit={}", this.queryId, this.chunkId, this.limitId);
            this.iterator = this.client.getQueryResult(this.queryId, this.chunkId.getAndIncrement(), this.omitSchema.getAndSet(true));
        }
        if (this.iterator.hasNext()) {
            return true;
        }
        if (this.chunkId.get() < this.limitId) {
            log.info("Fetching new chunk based query result stream. queryId={}, chunkId={}, limit={}", this.queryId, this.chunkId, this.limitId);
            this.iterator = this.client.getQueryResult(this.queryId, this.chunkId.getAndIncrement(), this.omitSchema.get());
        }
        return this.iterator.hasNext();
    }

    @Override
    public QueryResult next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.iterator.next();
    }

    @Generated
    private ChunkBased(@NonNull HyperGrpcClientExecutor client, @NonNull String queryId, AtomicLong chunkId, long limitId, AtomicBoolean omitSchema) {
        if (client == null) {
            throw new IllegalArgumentException("client is marked non-null but is null");
        }
        if (queryId == null) {
            throw new IllegalArgumentException("queryId is marked non-null but is null");
        }
        this.client = client;
        this.queryId = queryId;
        this.chunkId = chunkId;
        this.limitId = limitId;
        this.omitSchema = omitSchema;
    }
}

