/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.core.listener;

import com.salesforce.datacloud.jdbc.core.DataCloudResultSet;
import com.salesforce.datacloud.jdbc.core.HyperGrpcClientExecutor;
import com.salesforce.datacloud.jdbc.core.StreamingResultSet;
import com.salesforce.datacloud.jdbc.core.listener.QueryStatusListener;
import com.salesforce.datacloud.jdbc.core.partial.ChunkBased;
import com.salesforce.datacloud.jdbc.exception.DataCloudJDBCException;
import com.salesforce.datacloud.jdbc.exception.QueryExceptionHandler;
import com.salesforce.datacloud.jdbc.util.StreamUtilities;
import com.salesforce.datacloud.query.v3.DataCloudQueryStatus;
import com.salesforce.datacloud.shaded.io.grpc.StatusRuntimeException;
import java.sql.SQLException;
import java.time.Duration;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import salesforce.cdp.hyperdb.v1.ExecuteQueryResponse;
import salesforce.cdp.hyperdb.v1.QueryResult;

@Deprecated
public class AsyncQueryStatusListener
implements QueryStatusListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsyncQueryStatusListener.class);
    private final String queryId;
    private final String query;
    private final HyperGrpcClientExecutor client;
    private final Duration timeout;

    public static AsyncQueryStatusListener of(String query, HyperGrpcClientExecutor client, Duration timeout2) throws SQLException {
        try {
            ExecuteQueryResponse result = client.executeAsyncQuery(query).next();
            String queryId = result.getQueryInfo().getQueryStatus().getQueryId();
            log.info("Executing async query. queryId={}, timeout={}", (Object)queryId, (Object)timeout2);
            return AsyncQueryStatusListener.builder().queryId(queryId).query(query).client(client).timeout(timeout2).build();
        }
        catch (StatusRuntimeException ex) {
            throw QueryExceptionHandler.createQueryException(query, ex);
        }
    }

    @Override
    public String getStatus() throws DataCloudJDBCException {
        return this.client.getQueryStatus(this.queryId).map(DataCloudQueryStatus::getCompletionStatus).map(Enum::name).findFirst().orElse("UNKNOWN");
    }

    @Override
    public DataCloudResultSet generateResultSet() throws DataCloudJDBCException {
        return StreamingResultSet.of(this.queryId, this.client, this.stream().iterator());
    }

    @Override
    public Stream<QueryResult> stream() throws DataCloudJDBCException {
        DataCloudQueryStatus status = this.client.waitForQueryStatus(this.queryId, this.timeout, DataCloudQueryStatus::allResultsProduced);
        ChunkBased iterator2 = ChunkBased.of(this.client, this.queryId, 0L, status.getChunkCount(), false);
        return StreamUtilities.toStream(iterator2);
    }

    @Generated
    AsyncQueryStatusListener(String queryId, String query, HyperGrpcClientExecutor client, Duration timeout2) {
        this.queryId = queryId;
        this.query = query;
        this.client = client;
        this.timeout = timeout2;
    }

    @Generated
    private static AsyncQueryStatusListenerBuilder builder() {
        return new AsyncQueryStatusListenerBuilder();
    }

    @Override
    @Generated
    public String getQueryId() {
        return this.queryId;
    }

    @Override
    @Generated
    public String getQuery() {
        return this.query;
    }

    @Generated
    private static class AsyncQueryStatusListenerBuilder {
        @Generated
        private String queryId;
        @Generated
        private String query;
        @Generated
        private HyperGrpcClientExecutor client;
        @Generated
        private Duration timeout;

        @Generated
        AsyncQueryStatusListenerBuilder() {
        }

        @Generated
        private AsyncQueryStatusListenerBuilder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        @Generated
        private AsyncQueryStatusListenerBuilder query(String query) {
            this.query = query;
            return this;
        }

        @Generated
        private AsyncQueryStatusListenerBuilder client(HyperGrpcClientExecutor client) {
            this.client = client;
            return this;
        }

        @Generated
        private AsyncQueryStatusListenerBuilder timeout(Duration timeout2) {
            this.timeout = timeout2;
            return this;
        }

        @Generated
        private AsyncQueryStatusListener build() {
            return new AsyncQueryStatusListener(this.queryId, this.query, this.client, this.timeout);
        }

        @Generated
        public String toString() {
            return "AsyncQueryStatusListener.AsyncQueryStatusListenerBuilder(queryId=" + this.queryId + ", query=" + this.query + ", client=" + this.client + ", timeout=" + this.timeout + ")";
        }
    }
}

