/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.core.listener;

import com.salesforce.datacloud.jdbc.core.DataCloudResultSet;
import com.salesforce.datacloud.jdbc.core.HyperGrpcClientExecutor;
import com.salesforce.datacloud.jdbc.core.StreamingResultSet;
import com.salesforce.datacloud.jdbc.core.listener.QueryStatusListener;
import com.salesforce.datacloud.jdbc.core.partial.ChunkBased;
import com.salesforce.datacloud.jdbc.exception.DataCloudJDBCException;
import com.salesforce.datacloud.jdbc.exception.QueryExceptionHandler;
import com.salesforce.datacloud.jdbc.util.StreamUtilities;
import com.salesforce.datacloud.query.v3.DataCloudQueryStatus;
import com.salesforce.datacloud.shaded.io.grpc.StatusRuntimeException;
import java.sql.SQLException;
import java.time.Duration;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import salesforce.cdp.hyperdb.v1.ExecuteQueryResponse;
import salesforce.cdp.hyperdb.v1.QueryResult;

@Deprecated
public class AdaptiveQueryStatusListener
implements QueryStatusListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AdaptiveQueryStatusListener.class);
    private static final String BEFORE_READY = "The remaining adaptive results were requested before ready";
    private final String queryId;
    private final String query;
    private final HyperGrpcClientExecutor client;
    private final Duration timeout;
    private final Iterator<ExecuteQueryResponse> response;
    private final AtomicReference<DataCloudQueryStatus> lastStatus = new AtomicReference();

    public static AdaptiveQueryStatusListener of(String query, HyperGrpcClientExecutor client, Duration timeout2) throws SQLException {
        try {
            Iterator<ExecuteQueryResponse> response = client.executeQuery(query);
            String queryId = response.next().getQueryInfo().getQueryStatus().getQueryId();
            log.info("Executing adaptive query. queryId={}, timeout={}", (Object)queryId, (Object)timeout2);
            return new AdaptiveQueryStatusListener(queryId, query, client, timeout2, response);
        }
        catch (StatusRuntimeException ex) {
            throw QueryExceptionHandler.createQueryException(query, ex);
        }
    }

    public static RowBasedAdaptiveQueryStatusListener of(String query, HyperGrpcClientExecutor client, Duration timeout2, long maxRows) throws SQLException {
        try {
            Iterator<ExecuteQueryResponse> response = client.executeQuery(query, maxRows);
            String queryId = response.next().getQueryInfo().getQueryStatus().getQueryId();
            log.info("Executing adaptive query. queryId={}, timeout={}", (Object)queryId, (Object)timeout2);
            return new RowBasedAdaptiveQueryStatusListener(queryId, query, client, response);
        }
        catch (StatusRuntimeException ex) {
            throw QueryExceptionHandler.createQueryException(query, ex);
        }
    }

    @Override
    public String getStatus() throws DataCloudJDBCException {
        return this.client.getQueryStatus(this.queryId).map(DataCloudQueryStatus::getCompletionStatus).map(Enum::name).findFirst().orElse("UNKNOWN");
    }

    @Override
    public DataCloudResultSet generateResultSet() throws DataCloudJDBCException {
        return StreamingResultSet.of(this.queryId, this.client, this.stream().iterator());
    }

    @Override
    public Stream<QueryResult> stream() throws DataCloudJDBCException {
        return Stream.of(this::head, this::tail).flatMap(Supplier::get);
    }

    private Stream<QueryResult> head() {
        return StreamUtilities.toStream(this.response).map(this::mapHead).filter(Optional::isPresent).map(Optional::get);
    }

    private Optional<QueryResult> mapHead(ExecuteQueryResponse item) {
        Optional.ofNullable(item).map(ExecuteQueryResponse::getQueryInfo).flatMap(DataCloudQueryStatus::of).ifPresent(this.lastStatus::set);
        return Optional.ofNullable(item).map(ExecuteQueryResponse::getQueryResult);
    }

    private boolean allResultsInHead() {
        return Optional.ofNullable(this.lastStatus.get()).map(s2 -> s2.allResultsProduced() && s2.getChunkCount() < 2L).orElse(false);
    }

    private Stream<QueryResult> tail() {
        if (this.allResultsInHead()) {
            return Stream.empty();
        }
        DataCloudQueryStatus status = this.client.waitForQueryStatus(this.queryId, this.timeout, DataCloudQueryStatus::allResultsProduced);
        if (!status.allResultsProduced()) {
            throw new DataCloudJDBCException("The remaining adaptive results were requested before ready. queryId=" + this.queryId + ", timeout=" + this.timeout);
        }
        if (status.getChunkCount() < 2L) {
            return Stream.empty();
        }
        ChunkBased iterator2 = ChunkBased.of(this.client, this.queryId, 1L, status.getChunkCount() - 1L, true);
        return StreamUtilities.toStream(iterator2);
    }

    @Generated
    private AdaptiveQueryStatusListener(String queryId, String query, HyperGrpcClientExecutor client, Duration timeout2, Iterator<ExecuteQueryResponse> response) {
        this.queryId = queryId;
        this.query = query;
        this.client = client;
        this.timeout = timeout2;
        this.response = response;
    }

    @Override
    @Generated
    public String getQueryId() {
        return this.queryId;
    }

    @Override
    @Generated
    public String getQuery() {
        return this.query;
    }

    @Deprecated
    public static class RowBasedAdaptiveQueryStatusListener
    implements QueryStatusListener {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(RowBasedAdaptiveQueryStatusListener.class);
        private final String queryId;
        private final String query;
        private final HyperGrpcClientExecutor client;
        private final Iterator<ExecuteQueryResponse> response;
        private final AtomicReference<DataCloudQueryStatus> lastStatus = new AtomicReference();

        @Override
        public String getStatus() throws DataCloudJDBCException {
            return this.client.getQueryStatus(this.queryId).map(DataCloudQueryStatus::getCompletionStatus).map(Enum::name).findFirst().orElse("UNKNOWN");
        }

        @Override
        public DataCloudResultSet generateResultSet() throws DataCloudJDBCException {
            return StreamingResultSet.of(this.queryId, this.client, this.stream().iterator());
        }

        @Override
        public Stream<QueryResult> stream() throws DataCloudJDBCException {
            return StreamUtilities.toStream(this.response).map(this::mapHead).filter(Optional::isPresent).map(Optional::get);
        }

        private Optional<QueryResult> mapHead(ExecuteQueryResponse item) {
            Optional.ofNullable(item).map(ExecuteQueryResponse::getQueryInfo).flatMap(DataCloudQueryStatus::of).ifPresent(this.lastStatus::set);
            return Optional.ofNullable(item).map(ExecuteQueryResponse::getQueryResult);
        }

        @Generated
        RowBasedAdaptiveQueryStatusListener(String queryId, String query, HyperGrpcClientExecutor client, Iterator<ExecuteQueryResponse> response) {
            this.queryId = queryId;
            this.query = query;
            this.client = client;
            this.response = response;
        }

        @Override
        @Generated
        public String getQueryId() {
            return this.queryId;
        }

        @Override
        @Generated
        public String getQuery() {
            return this.query;
        }
    }
}

