/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.core.accessor.impl;

import com.salesforce.datacloud.jdbc.exception.DataCloudJDBCException;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.TimeStampMicroTZVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.TimeStampMicroVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.TimeStampMilliTZVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.TimeStampMilliVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.TimeStampNanoTZVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.TimeStampNanoVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.TimeStampSecTZVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.TimeStampSecVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.TimeStampVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.holders.NullableTimeStampMicroHolder;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.holders.NullableTimeStampMicroTZHolder;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.holders.NullableTimeStampMilliHolder;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.holders.NullableTimeStampMilliTZHolder;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.holders.NullableTimeStampNanoHolder;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.holders.NullableTimeStampNanoTZHolder;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.holders.NullableTimeStampSecHolder;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.holders.NullableTimeStampSecTZHolder;
import java.sql.SQLException;
import lombok.Generated;

final class TimeStampVectorGetter {
    private static final String INVALID_VECTOR_ERROR_RESPONSE = "Unsupported Timestamp vector provided";

    static Getter createGetter(TimeStampVector vector) throws SQLException {
        if (vector instanceof TimeStampNanoVector) {
            return TimeStampVectorGetter.createGetter((TimeStampNanoVector)vector);
        }
        if (vector instanceof TimeStampNanoTZVector) {
            return TimeStampVectorGetter.createGetter((TimeStampNanoTZVector)vector);
        }
        if (vector instanceof TimeStampMicroVector) {
            return TimeStampVectorGetter.createGetter((TimeStampMicroVector)vector);
        }
        if (vector instanceof TimeStampMicroTZVector) {
            return TimeStampVectorGetter.createGetter((TimeStampMicroTZVector)vector);
        }
        if (vector instanceof TimeStampMilliVector) {
            return TimeStampVectorGetter.createGetter((TimeStampMilliVector)vector);
        }
        if (vector instanceof TimeStampMilliTZVector) {
            return TimeStampVectorGetter.createGetter((TimeStampMilliTZVector)vector);
        }
        if (vector instanceof TimeStampSecVector) {
            return TimeStampVectorGetter.createGetter((TimeStampSecVector)vector);
        }
        if (vector instanceof TimeStampSecTZVector) {
            return TimeStampVectorGetter.createGetter((TimeStampSecTZVector)vector);
        }
        UnsupportedOperationException rootCauseException = new UnsupportedOperationException(INVALID_VECTOR_ERROR_RESPONSE);
        throw new DataCloudJDBCException(INVALID_VECTOR_ERROR_RESPONSE, "22007", rootCauseException);
    }

    private static Getter createGetter(TimeStampNanoVector vector) {
        NullableTimeStampNanoHolder auxHolder = new NullableTimeStampNanoHolder();
        return (index, holder) -> {
            vector.get(index, auxHolder);
            holder.isSet = auxHolder.isSet;
            holder.value = auxHolder.value;
        };
    }

    private static Getter createGetter(TimeStampNanoTZVector vector) {
        NullableTimeStampNanoTZHolder auxHolder = new NullableTimeStampNanoTZHolder();
        return (index, holder) -> {
            vector.get(index, auxHolder);
            holder.isSet = auxHolder.isSet;
            holder.value = auxHolder.value;
        };
    }

    private static Getter createGetter(TimeStampMicroVector vector) {
        NullableTimeStampMicroHolder auxHolder = new NullableTimeStampMicroHolder();
        return (index, holder) -> {
            vector.get(index, auxHolder);
            holder.isSet = auxHolder.isSet;
            holder.value = auxHolder.value;
        };
    }

    private static Getter createGetter(TimeStampMicroTZVector vector) {
        NullableTimeStampMicroTZHolder auxHolder = new NullableTimeStampMicroTZHolder();
        return (index, holder) -> {
            vector.get(index, auxHolder);
            holder.isSet = auxHolder.isSet;
            holder.value = auxHolder.value;
        };
    }

    private static Getter createGetter(TimeStampMilliVector vector) {
        NullableTimeStampMilliHolder auxHolder = new NullableTimeStampMilliHolder();
        return (index, holder) -> {
            vector.get(index, auxHolder);
            holder.isSet = auxHolder.isSet;
            holder.value = auxHolder.value;
        };
    }

    private static Getter createGetter(TimeStampMilliTZVector vector) {
        NullableTimeStampMilliTZHolder auxHolder = new NullableTimeStampMilliTZHolder();
        return (index, holder) -> {
            vector.get(index, auxHolder);
            holder.isSet = auxHolder.isSet;
            holder.value = auxHolder.value;
        };
    }

    private static Getter createGetter(TimeStampSecVector vector) {
        NullableTimeStampSecHolder auxHolder = new NullableTimeStampSecHolder();
        return (index, holder) -> {
            vector.get(index, auxHolder);
            holder.isSet = auxHolder.isSet;
            holder.value = auxHolder.value;
        };
    }

    private static Getter createGetter(TimeStampSecTZVector vector) {
        NullableTimeStampSecTZHolder auxHolder = new NullableTimeStampSecTZHolder();
        return (index, holder) -> {
            vector.get(index, auxHolder);
            holder.isSet = auxHolder.isSet;
            holder.value = auxHolder.value;
        };
    }

    @Generated
    private TimeStampVectorGetter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @FunctionalInterface
    static interface Getter {
        public void get(int var1, Holder var2);
    }

    static class Holder {
        int isSet;
        long value;

        Holder() {
        }
    }
}

