/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.core.accessor.impl;

import com.salesforce.datacloud.jdbc.core.accessor.QueryJDBCAccessor;
import com.salesforce.datacloud.jdbc.core.accessor.QueryJDBCAccessorFactory;
import com.salesforce.datacloud.jdbc.core.accessor.impl.TimeStampVectorGetter;
import com.salesforce.datacloud.jdbc.exception.DataCloudJDBCException;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.TimeStampVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.types.pojo.ArrowType;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.util.DateUtility;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.function.IntSupplier;

public class TimeStampVectorAccessor
extends QueryJDBCAccessor {
    private static final String ISO_DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static final String ISO_DATE_TIME_SEC_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final String INVALID_UNIT_ERROR_RESPONSE = "Invalid Arrow time unit";
    private final TimeZone timeZone;
    private final TimeUnit timeUnit;
    private final LongToLocalDateTime longToLocalDateTime;
    private final TimeStampVectorGetter.Holder holder;
    private final TimeStampVectorGetter.Getter getter;

    public TimeStampVectorAccessor(TimeStampVector vector, IntSupplier currentRowSupplier, QueryJDBCAccessorFactory.WasNullConsumer wasNullConsumer) throws SQLException {
        super(currentRowSupplier, wasNullConsumer);
        this.timeZone = TimeStampVectorAccessor.getTimeZoneForVector(vector);
        this.timeUnit = TimeStampVectorAccessor.getTimeUnitForVector(vector);
        this.longToLocalDateTime = TimeStampVectorAccessor.getLongToLocalDateTimeForVector(vector, this.timeZone);
        this.holder = new TimeStampVectorGetter.Holder();
        this.getter = TimeStampVectorGetter.createGetter(vector);
    }

    @Override
    public Date getDate(Calendar calendar) {
        LocalDateTime localDateTime = this.getLocalDateTime(calendar);
        if (localDateTime == null) {
            return null;
        }
        return new Date(Timestamp.valueOf(localDateTime).getTime());
    }

    @Override
    public Time getTime(Calendar calendar) {
        LocalDateTime localDateTime = this.getLocalDateTime(calendar);
        if (localDateTime == null) {
            return null;
        }
        return new Time(Timestamp.valueOf(localDateTime).getTime());
    }

    @Override
    public Timestamp getTimestamp(Calendar calendar) {
        LocalDateTime localDateTime = this.getLocalDateTime(calendar);
        if (localDateTime == null) {
            return null;
        }
        return Timestamp.valueOf(localDateTime);
    }

    @Override
    public Class<?> getObjectClass() {
        return Timestamp.class;
    }

    @Override
    public Object getObject() {
        return this.getTimestamp(null);
    }

    @Override
    public String getString() {
        LocalDateTime localDateTime = this.getLocalDateTime(null);
        if (localDateTime == null) {
            return null;
        }
        if (this.timeUnit == TimeUnit.SECONDS) {
            return localDateTime.format(DateTimeFormatter.ofPattern(ISO_DATE_TIME_SEC_FORMAT));
        }
        return localDateTime.format(DateTimeFormatter.ofPattern(ISO_DATE_TIME_FORMAT));
    }

    private LocalDateTime getLocalDateTime(Calendar calendar) {
        this.getter.get(this.getCurrentRow(), this.holder);
        this.wasNull = this.holder.isSet == 0;
        this.wasNullConsumer.setWasNull(this.wasNull);
        if (this.wasNull) {
            return null;
        }
        long value = this.holder.value;
        LocalDateTime localDateTime = this.longToLocalDateTime.fromLong(value);
        if (calendar != null) {
            TimeZone timeZone = calendar.getTimeZone();
            ZonedDateTime utcZonedDateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(this.timeUnit.toMillis(value)), ZoneOffset.UTC);
            localDateTime = utcZonedDateTime.withZoneSameInstant(timeZone.toZoneId()).toLocalDateTime();
        }
        return localDateTime;
    }

    private static LongToLocalDateTime getLongToLocalDateTimeForVector(TimeStampVector vector, TimeZone timeZone) throws SQLException {
        String timeZoneID = timeZone.getID();
        ArrowType.Timestamp arrowType = (ArrowType.Timestamp)vector.getField().getFieldType().getType();
        switch (arrowType.getUnit()) {
            case NANOSECOND: {
                return nanoseconds -> DateUtility.getLocalDateTimeFromEpochNano(nanoseconds, timeZoneID);
            }
            case MICROSECOND: {
                return microseconds -> DateUtility.getLocalDateTimeFromEpochMicro(microseconds, timeZoneID);
            }
            case MILLISECOND: {
                return milliseconds -> DateUtility.getLocalDateTimeFromEpochMilli(milliseconds, timeZoneID);
            }
            case SECOND: {
                return seconds -> DateUtility.getLocalDateTimeFromEpochMilli(TimeUnit.SECONDS.toMillis(seconds), timeZoneID);
            }
        }
        UnsupportedOperationException rootCauseException = new UnsupportedOperationException(INVALID_UNIT_ERROR_RESPONSE);
        throw new DataCloudJDBCException(INVALID_UNIT_ERROR_RESPONSE, "22007", rootCauseException);
    }

    protected static TimeZone getTimeZoneForVector(TimeStampVector vector) {
        ArrowType.Timestamp arrowType = (ArrowType.Timestamp)vector.getField().getFieldType().getType();
        String timezoneName = arrowType.getTimezone();
        return timezoneName == null ? TimeZone.getTimeZone("UTC") : TimeZone.getTimeZone(timezoneName);
    }

    protected static TimeUnit getTimeUnitForVector(TimeStampVector vector) throws SQLException {
        ArrowType.Timestamp arrowType = (ArrowType.Timestamp)vector.getField().getFieldType().getType();
        switch (arrowType.getUnit()) {
            case NANOSECOND: {
                return TimeUnit.NANOSECONDS;
            }
            case MICROSECOND: {
                return TimeUnit.MICROSECONDS;
            }
            case MILLISECOND: {
                return TimeUnit.MILLISECONDS;
            }
            case SECOND: {
                return TimeUnit.SECONDS;
            }
        }
        UnsupportedOperationException rootCauseException = new UnsupportedOperationException(INVALID_UNIT_ERROR_RESPONSE);
        throw new DataCloudJDBCException(INVALID_UNIT_ERROR_RESPONSE, "22007", rootCauseException);
    }

    @FunctionalInterface
    static interface LongToLocalDateTime {
        public LocalDateTime fromLong(long var1);
    }
}

