/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.core.accessor.impl;

import com.salesforce.datacloud.jdbc.core.accessor.QueryJDBCAccessorFactory;
import com.salesforce.datacloud.jdbc.core.accessor.impl.BaseListVectorAccessor;
import com.salesforce.datacloud.shaded.org.apache.arrow.memory.ArrowBuf;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.FieldVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.complex.ListVector;
import java.sql.SQLException;
import java.util.function.IntSupplier;

public class ListVectorAccessor
extends BaseListVectorAccessor {
    private final ListVector vector;

    public ListVectorAccessor(ListVector vector, IntSupplier currentRowSupplier, QueryJDBCAccessorFactory.WasNullConsumer wasNullConsumer) {
        super(currentRowSupplier, wasNullConsumer);
        this.vector = vector;
    }

    @Override
    public Object getObject() throws SQLException {
        return this.getListObject(this.vector::getObject);
    }

    @Override
    protected long getStartOffset(int index) {
        ArrowBuf offsetBuffer = this.vector.getOffsetBuffer();
        return offsetBuffer.getInt((long)index * 4L);
    }

    @Override
    protected long getEndOffset(int index) {
        ArrowBuf offsetBuffer = this.vector.getOffsetBuffer();
        return offsetBuffer.getInt((long)(index + 1) * 4L);
    }

    @Override
    protected FieldVector getDataVector() {
        return this.vector.getDataVector();
    }

    @Override
    protected boolean isNull(int index) {
        return this.vector.isNull(index);
    }
}

