/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.core.accessor.impl;

import com.salesforce.datacloud.jdbc.core.accessor.QueryJDBCAccessor;
import com.salesforce.datacloud.jdbc.core.accessor.QueryJDBCAccessorFactory;
import com.salesforce.datacloud.jdbc.core.accessor.impl.DataCloudArray;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.FieldVector;
import java.sql.Array;
import java.sql.SQLException;
import java.util.List;
import java.util.function.IntSupplier;

public abstract class BaseListVectorAccessor
extends QueryJDBCAccessor {
    protected abstract long getStartOffset(int var1);

    protected abstract long getEndOffset(int var1);

    protected abstract FieldVector getDataVector();

    protected abstract boolean isNull(int var1);

    protected BaseListVectorAccessor(IntSupplier currentRowSupplier, QueryJDBCAccessorFactory.WasNullConsumer wasNullConsumer) {
        super(currentRowSupplier, wasNullConsumer);
    }

    @Override
    public Class<?> getObjectClass() {
        return List.class;
    }

    protected List<?> getListObject(VectorProvider vectorProvider) throws SQLException {
        List<?> object = vectorProvider.getObject(this.getCurrentRow());
        this.wasNull = object == null;
        this.wasNullConsumer.setWasNull(this.wasNull);
        return object;
    }

    @Override
    public Array getArray() {
        int index = this.getCurrentRow();
        FieldVector dataVector = this.getDataVector();
        this.wasNull = this.isNull(index);
        this.wasNullConsumer.setWasNull(this.wasNull);
        if (this.wasNull) {
            return null;
        }
        long startOffset = this.getStartOffset(index);
        long endOffset = this.getEndOffset(index);
        long valuesCount = endOffset - startOffset;
        return new DataCloudArray(dataVector, startOffset, valuesCount);
    }

    protected static interface VectorProvider {
        public List<?> getObject(int var1) throws SQLException;
    }
}

