/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.core.accessor.impl;

import com.salesforce.datacloud.jdbc.core.accessor.QueryJDBCAccessor;
import com.salesforce.datacloud.jdbc.core.accessor.QueryJDBCAccessorFactory;
import com.salesforce.datacloud.jdbc.core.accessor.impl.NumericGetter;
import com.salesforce.datacloud.jdbc.exception.DataCloudJDBCException;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.BaseIntVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.BigIntVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.IntVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.SmallIntVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.TinyIntVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.UInt4Vector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.types.Types;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.function.IntSupplier;

public class BaseIntVectorAccessor
extends QueryJDBCAccessor {
    private final Types.MinorType type;
    private final boolean isUnsigned;
    private final NumericGetter.Getter getter;
    private final NumericGetter.NumericHolder holder;
    private static final String INVALID_TYPE_ERROR_RESPONSE = "Invalid Minor Type provided";

    public BaseIntVectorAccessor(TinyIntVector vector, IntSupplier currentRowSupplier, QueryJDBCAccessorFactory.WasNullConsumer setCursorWasNull) throws SQLException {
        this(vector, currentRowSupplier, false, setCursorWasNull);
    }

    public BaseIntVectorAccessor(SmallIntVector vector, IntSupplier currentRowSupplier, QueryJDBCAccessorFactory.WasNullConsumer setCursorWasNull) throws SQLException {
        this(vector, currentRowSupplier, false, setCursorWasNull);
    }

    public BaseIntVectorAccessor(IntVector vector, IntSupplier currentRowSupplier, QueryJDBCAccessorFactory.WasNullConsumer setCursorWasNull) throws SQLException {
        this(vector, currentRowSupplier, false, setCursorWasNull);
    }

    public BaseIntVectorAccessor(BigIntVector vector, IntSupplier currentRowSupplier, QueryJDBCAccessorFactory.WasNullConsumer setCursorWasNull) throws SQLException {
        this(vector, currentRowSupplier, false, setCursorWasNull);
    }

    private BaseIntVectorAccessor(BaseIntVector vector, IntSupplier currentRowSupplier, boolean isUnsigned, QueryJDBCAccessorFactory.WasNullConsumer setCursorWasNull) throws SQLException {
        super(currentRowSupplier, setCursorWasNull);
        this.type = vector.getMinorType();
        this.holder = new NumericGetter.NumericHolder();
        this.getter = NumericGetter.createGetter(vector);
        this.isUnsigned = isUnsigned;
    }

    public BaseIntVectorAccessor(UInt4Vector vector, IntSupplier currentRowSupplier, QueryJDBCAccessorFactory.WasNullConsumer setCursorWasNull) throws SQLException {
        this(vector, currentRowSupplier, false, setCursorWasNull);
    }

    @Override
    public long getLong() {
        this.getter.get(this.getCurrentRow(), this.holder);
        this.wasNull = this.holder.isSet == 0;
        this.wasNullConsumer.setWasNull(this.wasNull);
        if (this.wasNull) {
            return 0L;
        }
        return this.holder.value;
    }

    @Override
    public Class<?> getObjectClass() {
        return Long.class;
    }

    @Override
    public String getString() {
        long number = this.getLong();
        if (this.wasNull) {
            return null;
        }
        return this.isUnsigned ? Long.toUnsignedString(number) : Long.toString(number);
    }

    @Override
    public byte getByte() {
        return (byte)this.getLong();
    }

    @Override
    public short getShort() {
        return (short)this.getLong();
    }

    @Override
    public int getInt() {
        return (int)this.getLong();
    }

    @Override
    public float getFloat() {
        return this.getLong();
    }

    @Override
    public double getDouble() {
        return this.getLong();
    }

    @Override
    public BigDecimal getBigDecimal() {
        BigDecimal value = BigDecimal.valueOf(this.getLong());
        return this.wasNull ? null : value;
    }

    @Override
    public BigDecimal getBigDecimal(int scale) {
        BigDecimal value = BigDecimal.valueOf(this.getDouble()).setScale(scale, RoundingMode.HALF_UP);
        return this.wasNull ? null : value;
    }

    @Override
    public Number getObject() throws SQLException {
        Number number;
        switch (this.type) {
            case TINYINT: {
                number = this.getByte();
                break;
            }
            case SMALLINT: {
                number = this.getShort();
                break;
            }
            case INT: 
            case UINT4: {
                number = this.getInt();
                break;
            }
            case BIGINT: {
                number = this.getLong();
                break;
            }
            default: {
                UnsupportedOperationException rootCauseException = new UnsupportedOperationException(INVALID_TYPE_ERROR_RESPONSE);
                throw new DataCloudJDBCException(INVALID_TYPE_ERROR_RESPONSE, "2200G", rootCauseException);
            }
        }
        return this.wasNull ? (Number)null : (Number)number;
    }
}

