/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.core.accessor;

import com.salesforce.datacloud.jdbc.core.accessor.QueryJDBCAccessor;
import com.salesforce.datacloud.jdbc.core.accessor.impl.BaseIntVectorAccessor;
import com.salesforce.datacloud.jdbc.core.accessor.impl.BinaryVectorAccessor;
import com.salesforce.datacloud.jdbc.core.accessor.impl.BooleanVectorAccessor;
import com.salesforce.datacloud.jdbc.core.accessor.impl.DateVectorAccessor;
import com.salesforce.datacloud.jdbc.core.accessor.impl.DecimalVectorAccessor;
import com.salesforce.datacloud.jdbc.core.accessor.impl.DoubleVectorAccessor;
import com.salesforce.datacloud.jdbc.core.accessor.impl.FloatVectorAccessor;
import com.salesforce.datacloud.jdbc.core.accessor.impl.LargeListVectorAccessor;
import com.salesforce.datacloud.jdbc.core.accessor.impl.ListVectorAccessor;
import com.salesforce.datacloud.jdbc.core.accessor.impl.TimeStampVectorAccessor;
import com.salesforce.datacloud.jdbc.core.accessor.impl.TimeVectorAccessor;
import com.salesforce.datacloud.jdbc.core.accessor.impl.VarCharVectorAccessor;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.BigIntVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.BitVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.DateDayVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.DateMilliVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.DecimalVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.FixedSizeBinaryVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.Float4Vector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.Float8Vector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.IntVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.LargeVarBinaryVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.LargeVarCharVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.SmallIntVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.TimeMicroVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.TimeMilliVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.TimeNanoVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.TimeSecVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.TimeStampMicroTZVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.TimeStampMicroVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.TimeStampMilliTZVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.TimeStampMilliVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.TimeStampNanoTZVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.TimeStampNanoVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.TimeStampSecTZVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.TimeStampSecVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.TinyIntVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.UInt4Vector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.ValueVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.VarBinaryVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.VarCharVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.complex.LargeListVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.complex.ListVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.types.Types;
import java.sql.SQLException;
import java.util.function.IntSupplier;

public class QueryJDBCAccessorFactory {
    public static QueryJDBCAccessor createAccessor(ValueVector vector, IntSupplier getCurrentRow, WasNullConsumer wasNullConsumer) throws SQLException {
        Types.MinorType arrowType = Types.getMinorTypeForArrowType(vector.getField().getType());
        if (arrowType.equals((Object)Types.MinorType.VARCHAR)) {
            return new VarCharVectorAccessor((VarCharVector)vector, getCurrentRow, wasNullConsumer);
        }
        if (arrowType.equals((Object)Types.MinorType.LARGEVARCHAR)) {
            return new VarCharVectorAccessor((LargeVarCharVector)vector, getCurrentRow, wasNullConsumer);
        }
        if (arrowType.equals((Object)Types.MinorType.DECIMAL)) {
            return new DecimalVectorAccessor((DecimalVector)vector, getCurrentRow, wasNullConsumer);
        }
        if (arrowType.equals((Object)Types.MinorType.BIT)) {
            return new BooleanVectorAccessor((BitVector)vector, getCurrentRow, wasNullConsumer);
        }
        if (arrowType.equals((Object)Types.MinorType.FLOAT4)) {
            return new FloatVectorAccessor((Float4Vector)vector, getCurrentRow, wasNullConsumer);
        }
        if (arrowType.equals((Object)Types.MinorType.FLOAT8)) {
            return new DoubleVectorAccessor((Float8Vector)vector, getCurrentRow, wasNullConsumer);
        }
        if (arrowType.equals((Object)Types.MinorType.TINYINT)) {
            return new BaseIntVectorAccessor((TinyIntVector)vector, getCurrentRow, wasNullConsumer);
        }
        if (arrowType.equals((Object)Types.MinorType.SMALLINT)) {
            return new BaseIntVectorAccessor((SmallIntVector)vector, getCurrentRow, wasNullConsumer);
        }
        if (arrowType.equals((Object)Types.MinorType.INT)) {
            return new BaseIntVectorAccessor((IntVector)vector, getCurrentRow, wasNullConsumer);
        }
        if (arrowType.equals((Object)Types.MinorType.BIGINT)) {
            return new BaseIntVectorAccessor((BigIntVector)vector, getCurrentRow, wasNullConsumer);
        }
        if (arrowType.equals((Object)Types.MinorType.UINT4)) {
            return new BaseIntVectorAccessor((UInt4Vector)vector, getCurrentRow, wasNullConsumer);
        }
        if (arrowType.equals((Object)Types.MinorType.VARBINARY)) {
            return new BinaryVectorAccessor((VarBinaryVector)vector, getCurrentRow, wasNullConsumer);
        }
        if (arrowType.equals((Object)Types.MinorType.LARGEVARBINARY)) {
            return new BinaryVectorAccessor((LargeVarBinaryVector)vector, getCurrentRow, wasNullConsumer);
        }
        if (arrowType.equals((Object)Types.MinorType.FIXEDSIZEBINARY)) {
            return new BinaryVectorAccessor((FixedSizeBinaryVector)vector, getCurrentRow, wasNullConsumer);
        }
        if (arrowType.equals((Object)Types.MinorType.DATEDAY)) {
            return new DateVectorAccessor((DateDayVector)vector, getCurrentRow, wasNullConsumer);
        }
        if (arrowType.equals((Object)Types.MinorType.DATEMILLI)) {
            return new DateVectorAccessor((DateMilliVector)vector, getCurrentRow, wasNullConsumer);
        }
        if (arrowType.equals((Object)Types.MinorType.TIMENANO)) {
            return new TimeVectorAccessor((TimeNanoVector)vector, getCurrentRow, wasNullConsumer);
        }
        if (arrowType.equals((Object)Types.MinorType.TIMEMICRO)) {
            return new TimeVectorAccessor((TimeMicroVector)vector, getCurrentRow, wasNullConsumer);
        }
        if (arrowType.equals((Object)Types.MinorType.TIMEMILLI)) {
            return new TimeVectorAccessor((TimeMilliVector)vector, getCurrentRow, wasNullConsumer);
        }
        if (arrowType.equals((Object)Types.MinorType.TIMESEC)) {
            return new TimeVectorAccessor((TimeSecVector)vector, getCurrentRow, wasNullConsumer);
        }
        if (arrowType.equals((Object)Types.MinorType.TIMESTAMPSECTZ)) {
            return new TimeStampVectorAccessor((TimeStampSecTZVector)vector, getCurrentRow, wasNullConsumer);
        }
        if (arrowType.equals((Object)Types.MinorType.TIMESTAMPSEC)) {
            return new TimeStampVectorAccessor((TimeStampSecVector)vector, getCurrentRow, wasNullConsumer);
        }
        if (arrowType.equals((Object)Types.MinorType.TIMESTAMPMILLITZ)) {
            return new TimeStampVectorAccessor((TimeStampMilliTZVector)vector, getCurrentRow, wasNullConsumer);
        }
        if (arrowType.equals((Object)Types.MinorType.TIMESTAMPMILLI)) {
            return new TimeStampVectorAccessor((TimeStampMilliVector)vector, getCurrentRow, wasNullConsumer);
        }
        if (arrowType.equals((Object)Types.MinorType.TIMESTAMPMICROTZ)) {
            return new TimeStampVectorAccessor((TimeStampMicroTZVector)vector, getCurrentRow, wasNullConsumer);
        }
        if (arrowType.equals((Object)Types.MinorType.TIMESTAMPMICRO)) {
            return new TimeStampVectorAccessor((TimeStampMicroVector)vector, getCurrentRow, wasNullConsumer);
        }
        if (arrowType.equals((Object)Types.MinorType.TIMESTAMPNANOTZ)) {
            return new TimeStampVectorAccessor((TimeStampNanoTZVector)vector, getCurrentRow, wasNullConsumer);
        }
        if (arrowType.equals((Object)Types.MinorType.TIMESTAMPNANO)) {
            return new TimeStampVectorAccessor((TimeStampNanoVector)vector, getCurrentRow, wasNullConsumer);
        }
        if (arrowType.equals((Object)Types.MinorType.LIST)) {
            return new ListVectorAccessor((ListVector)vector, getCurrentRow, wasNullConsumer);
        }
        if (arrowType.equals((Object)Types.MinorType.LARGELIST)) {
            return new LargeListVectorAccessor((LargeListVector)vector, getCurrentRow, wasNullConsumer);
        }
        throw new UnsupportedOperationException("Unsupported vector type: " + vector.getClass().getName());
    }

    @FunctionalInterface
    public static interface WasNullConsumer {
        public void setWasNull(boolean var1);
    }
}

