/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.core;

import com.salesforce.datacloud.jdbc.exception.DataCloudJDBCException;
import com.salesforce.datacloud.shaded.org.apache.calcite.avatica.util.AbstractCursor;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.NonNull;

public class MetadataCursor
extends AbstractCursor {
    private final int rowCount;
    private int currentRow = -1;
    private List<Object> data;
    private final AtomicBoolean closed = new AtomicBoolean();

    public MetadataCursor(@NonNull List<Object> data) {
        if (data == null) {
            throw new IllegalArgumentException("data is marked non-null but is null");
        }
        this.data = data;
        this.rowCount = data.size();
    }

    @Override
    protected AbstractCursor.Getter createGetter(int i) {
        return new ListGetter(i);
    }

    @Override
    public boolean next() {
        ++this.currentRow;
        return this.currentRow < this.rowCount;
    }

    @Override
    public void close() {
        try {
            this.closed.set(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected class ListGetter
    extends AbstractCursor.AbstractGetter {
        protected final int index;

        public ListGetter(int index) {
            super(MetadataCursor.this);
            this.index = index;
        }

        @Override
        public Object getObject() throws SQLException {
            Object o;
            try {
                o = ((List)MetadataCursor.this.data.get(MetadataCursor.this.currentRow)).get(this.index);
            }
            catch (RuntimeException e) {
                throw new DataCloudJDBCException(e);
            }
            ((MetadataCursor)MetadataCursor.this).wasNull[0] = o == null;
            return o;
        }
    }
}

