/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.core;

import com.salesforce.datacloud.jdbc.core.ConnectionQuerySettings;
import com.salesforce.datacloud.jdbc.core.partial.DataCloudQueryPolling;
import com.salesforce.datacloud.jdbc.exception.DataCloudJDBCException;
import com.salesforce.datacloud.jdbc.interceptor.QueryIdHeaderInterceptor;
import com.salesforce.datacloud.jdbc.logging.ElapsedLogger;
import com.salesforce.datacloud.jdbc.util.StreamUtilities;
import com.salesforce.datacloud.jdbc.util.Unstable;
import com.salesforce.datacloud.query.v3.DataCloudQueryStatus;
import java.sql.SQLException;
import java.time.Duration;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import salesforce.cdp.hyperdb.v1.CancelQueryParam;
import salesforce.cdp.hyperdb.v1.ExecuteQueryResponse;
import salesforce.cdp.hyperdb.v1.HyperServiceGrpc;
import salesforce.cdp.hyperdb.v1.OutputFormat;
import salesforce.cdp.hyperdb.v1.QueryInfo;
import salesforce.cdp.hyperdb.v1.QueryInfoParam;
import salesforce.cdp.hyperdb.v1.QueryParam;
import salesforce.cdp.hyperdb.v1.QueryResult;
import salesforce.cdp.hyperdb.v1.QueryResultParam;
import salesforce.cdp.hyperdb.v1.ResultRange;

@Unstable
public class HyperGrpcClientExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HyperGrpcClientExecutor.class);
    public static final int HYPER_MAX_ROW_LIMIT_BYTE_SIZE = 0x1400000;
    public static final int HYPER_MIN_ROW_LIMIT_BYTE_SIZE = 1024;
    @NonNull
    private final HyperServiceGrpc.HyperServiceBlockingStub stub;
    private final int byteLimit;
    private final QueryParam settingsQueryParams;
    private QueryParam additionalQueryParams;

    public static HyperGrpcClientExecutor of(@NonNull HyperServiceGrpc.HyperServiceBlockingStub stub, @NonNull Properties properties) {
        if (stub == null) {
            throw new IllegalArgumentException("stub is marked non-null but is null");
        }
        if (properties == null) {
            throw new IllegalArgumentException("properties is marked non-null but is null");
        }
        return HyperGrpcClientExecutor.of(stub, properties, 0x1400000);
    }

    public static HyperGrpcClientExecutor of(@NonNull HyperServiceGrpc.HyperServiceBlockingStub stub, @NonNull Properties properties, int byteLimit) {
        if (stub == null) {
            throw new IllegalArgumentException("stub is marked non-null but is null");
        }
        if (properties == null) {
            throw new IllegalArgumentException("properties is marked non-null but is null");
        }
        HyperGrpcClientExecutorBuilder builder = HyperGrpcClientExecutor.builder().stub(stub).byteLimit(byteLimit);
        Map<String, String> settings = ConnectionQuerySettings.of(properties).getSettings();
        if (!settings.isEmpty()) {
            builder.settingsQueryParams(QueryParam.newBuilder().putAllSettings(settings).build());
        }
        return builder.build();
    }

    public HyperGrpcClientExecutor withQueryParams(QueryParam additionalQueryParams) {
        this.additionalQueryParams = additionalQueryParams;
        return this;
    }

    public Iterator<ExecuteQueryResponse> executeQuery(String sql) throws SQLException {
        return this.execute(sql, QueryParam.TransferMode.ADAPTIVE, QueryParam.newBuilder());
    }

    public Iterator<ExecuteQueryResponse> executeQuery(String sql, long maxRows) throws SQLException {
        QueryParam.Builder builder = QueryParam.newBuilder();
        if (maxRows > 0L) {
            log.info("setting row limit query. maxRows={}, byteLimit={}", (Object)maxRows, (Object)this.byteLimit);
            ResultRange.Builder range = ResultRange.newBuilder().setRowLimit(maxRows).setByteLimit(this.byteLimit);
            builder.setResultRange(range);
        }
        return this.execute(sql, QueryParam.TransferMode.ADAPTIVE, builder);
    }

    public Iterator<ExecuteQueryResponse> executeAsyncQuery(String sql) throws SQLException {
        return this.execute(sql, QueryParam.TransferMode.ASYNC, QueryParam.newBuilder());
    }

    public Iterator<QueryInfo> getQueryInfo(String queryId) throws DataCloudJDBCException {
        return ElapsedLogger.logTimedValue(() -> {
            QueryInfoParam param = this.getQueryInfoParam(queryId);
            return this.getStub(queryId).getQueryInfo(param);
        }, "getQueryInfo queryId=" + queryId, log);
    }

    public DataCloudQueryStatus waitForRowsAvailable(String queryId, long offset, long limit, Duration timeout2, boolean allowLessThan) throws DataCloudJDBCException {
        HyperServiceGrpc.HyperServiceBlockingStub stub = this.getStub(queryId);
        return DataCloudQueryPolling.waitForRowsAvailable(stub, queryId, offset, limit, timeout2, allowLessThan);
    }

    public DataCloudQueryStatus waitForChunksAvailable(String queryId, long offset, long limit, Duration timeout2, boolean allowLessThan) throws DataCloudJDBCException {
        HyperServiceGrpc.HyperServiceBlockingStub stub = this.getStub(queryId);
        return DataCloudQueryPolling.waitForChunksAvailable(stub, queryId, offset, limit, timeout2, allowLessThan);
    }

    public DataCloudQueryStatus waitForQueryStatus(String queryId, Duration timeout2, Predicate<DataCloudQueryStatus> predicate) throws DataCloudJDBCException {
        HyperServiceGrpc.HyperServiceBlockingStub stub = this.getStub(queryId);
        return DataCloudQueryPolling.waitForQueryStatus(stub, queryId, timeout2, predicate);
    }

    public Stream<DataCloudQueryStatus> getQueryStatus(String queryId) throws DataCloudJDBCException {
        Iterator<QueryInfo> iterator2 = this.getQueryInfo(queryId);
        return StreamUtilities.toStream(iterator2).map(DataCloudQueryStatus::of).filter(Optional::isPresent).map(Optional::get);
    }

    public void cancel(String queryId) throws DataCloudJDBCException {
        ElapsedLogger.logTimedValue(() -> {
            CancelQueryParam request = CancelQueryParam.newBuilder().setQueryId(queryId).build();
            HyperServiceGrpc.HyperServiceBlockingStub stub = this.getStub(queryId);
            stub.cancelQuery(request);
            return null;
        }, "cancel queryId=" + queryId, log);
    }

    public Iterator<QueryResult> getQueryResult(String queryId, long offset, long rowLimit, boolean omitSchema) throws DataCloudJDBCException {
        ResultRange.Builder rowRange = ResultRange.newBuilder().setRowOffset(offset).setRowLimit(rowLimit).setByteLimit(this.byteLimit);
        QueryResultParam param = QueryResultParam.newBuilder().setQueryId(queryId).setResultRange(rowRange).setOmitSchema(omitSchema).setOutputFormat(OutputFormat.ARROW_IPC).build();
        String message = String.format("getQueryResult queryId=%s, offset=%d, rowLimit=%d, byteLimit=%d, omitSchema=%s", queryId, offset, rowLimit, this.byteLimit, omitSchema);
        return ElapsedLogger.logTimedValue(() -> this.getStub(queryId).getQueryResult(param), message, log);
    }

    public Iterator<QueryResult> getQueryResult(String queryId, long chunkId, boolean omitSchema) {
        QueryResultParam param = this.getQueryResultParam(queryId, chunkId, omitSchema);
        return this.getStub(queryId).getQueryResult(param);
    }

    private QueryParam getQueryParams(String sql, QueryParam.Builder builder) {
        builder.setQuery(sql).setOutputFormat(OutputFormat.ARROW_IPC);
        if (this.additionalQueryParams != null) {
            builder.mergeFrom(this.additionalQueryParams);
        }
        if (this.settingsQueryParams != null) {
            builder.mergeFrom(this.settingsQueryParams);
        }
        return builder.build();
    }

    private QueryResultParam getQueryResultParam(String queryId, long chunkId, boolean omitSchema) {
        QueryResultParam.Builder builder = QueryResultParam.newBuilder().setQueryId(queryId).setChunkId(chunkId).setOmitSchema(omitSchema).setOutputFormat(OutputFormat.ARROW_IPC);
        return builder.build();
    }

    private QueryInfoParam getQueryInfoParam(String queryId) {
        return QueryInfoParam.newBuilder().setQueryId(queryId).setStreaming(true).build();
    }

    private Iterator<ExecuteQueryResponse> execute(String sql, QueryParam.TransferMode mode, QueryParam.Builder builder) throws SQLException {
        String message = "executeQuery. mode=" + mode.name();
        builder.setTransferMode(mode);
        return ElapsedLogger.logTimedValue(() -> {
            QueryParam request = this.getQueryParams(sql, builder);
            return this.stub.executeQuery(request);
        }, message, log);
    }

    private HyperServiceGrpc.HyperServiceBlockingStub getStub(@NonNull String queryId) {
        if (queryId == null) {
            throw new IllegalArgumentException("queryId is marked non-null but is null");
        }
        QueryIdHeaderInterceptor queryIdHeaderInterceptor = new QueryIdHeaderInterceptor(queryId);
        return (HyperServiceGrpc.HyperServiceBlockingStub)this.stub.withInterceptors(queryIdHeaderInterceptor);
    }

    @Generated
    HyperGrpcClientExecutor(@NonNull HyperServiceGrpc.HyperServiceBlockingStub stub, int byteLimit, QueryParam settingsQueryParams, QueryParam additionalQueryParams) {
        if (stub == null) {
            throw new IllegalArgumentException("stub is marked non-null but is null");
        }
        this.stub = stub;
        this.byteLimit = byteLimit;
        this.settingsQueryParams = settingsQueryParams;
        this.additionalQueryParams = additionalQueryParams;
    }

    @Generated
    private static HyperGrpcClientExecutorBuilder builder() {
        return new HyperGrpcClientExecutorBuilder();
    }

    @Generated
    private static class HyperGrpcClientExecutorBuilder {
        @Generated
        private HyperServiceGrpc.HyperServiceBlockingStub stub;
        @Generated
        private int byteLimit;
        @Generated
        private QueryParam settingsQueryParams;
        @Generated
        private QueryParam additionalQueryParams;

        @Generated
        HyperGrpcClientExecutorBuilder() {
        }

        @Generated
        private HyperGrpcClientExecutorBuilder stub(@NonNull HyperServiceGrpc.HyperServiceBlockingStub stub) {
            if (stub == null) {
                throw new IllegalArgumentException("stub is marked non-null but is null");
            }
            this.stub = stub;
            return this;
        }

        @Generated
        private HyperGrpcClientExecutorBuilder byteLimit(int byteLimit) {
            this.byteLimit = byteLimit;
            return this;
        }

        @Generated
        private HyperGrpcClientExecutorBuilder settingsQueryParams(QueryParam settingsQueryParams) {
            this.settingsQueryParams = settingsQueryParams;
            return this;
        }

        @Generated
        private HyperGrpcClientExecutorBuilder additionalQueryParams(QueryParam additionalQueryParams) {
            this.additionalQueryParams = additionalQueryParams;
            return this;
        }

        @Generated
        private HyperGrpcClientExecutor build() {
            return new HyperGrpcClientExecutor(this.stub, this.byteLimit, this.settingsQueryParams, this.additionalQueryParams);
        }

        @Generated
        public String toString() {
            return "HyperGrpcClientExecutor.HyperGrpcClientExecutorBuilder(stub=" + this.stub + ", byteLimit=" + this.byteLimit + ", settingsQueryParams=" + this.settingsQueryParams + ", additionalQueryParams=" + this.additionalQueryParams + ")";
        }
    }
}

