/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.core;

import com.salesforce.datacloud.jdbc.util.ConsumingPeekingIterator;
import com.salesforce.datacloud.shaded.com.google.protobuf.ByteString;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Iterator;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import salesforce.cdp.hyperdb.v1.QueryResult;
import salesforce.cdp.hyperdb.v1.QueryResultPartBinary;

public class ExecuteQueryResponseChannel
implements ReadableByteChannel {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExecuteQueryResponseChannel.class);
    private static final ByteBuffer empty = ByteBuffer.allocateDirect(0);
    private final Iterator<ByteBuffer> iterator;

    public static ExecuteQueryResponseChannel of(Stream<QueryResult> stream) {
        return new ExecuteQueryResponseChannel(stream.map(ExecuteQueryResponseChannel::fromQueryResult));
    }

    private ExecuteQueryResponseChannel(Stream<ByteBuffer> stream) {
        this.iterator = ConsumingPeekingIterator.of(stream, ExecuteQueryResponseChannel::isNotEmpty);
    }

    static ByteBuffer fromQueryResult(QueryResult queryResult) {
        return Optional.ofNullable(queryResult).map(QueryResult::getBinaryPart).map(QueryResultPartBinary::getData).map(ByteString::toByteArray).map(ByteBuffer::wrap).orElse(empty);
    }

    @Override
    public int read(ByteBuffer destination) {
        if (this.iterator.hasNext()) {
            return ExecuteQueryResponseChannel.transferToDestination(this.iterator.next(), destination);
        }
        return -1;
    }

    @Override
    public boolean isOpen() {
        return this.iterator.hasNext();
    }

    @Override
    public void close() throws IOException {
    }

    static int transferToDestination(ByteBuffer source2, ByteBuffer destination) {
        if (source2 == null) {
            return 0;
        }
        int transfer = Math.min(destination.remaining(), source2.remaining());
        if (transfer > 0) {
            destination.put(source2.array(), source2.arrayOffset() + source2.position(), transfer);
            source2.position(source2.position() + transfer);
        }
        return transfer;
    }

    static boolean isNotEmpty(ByteBuffer buffer) {
        return buffer.hasRemaining();
    }
}

