/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.core;

import com.salesforce.datacloud.jdbc.core.DataCloudConnection;
import com.salesforce.datacloud.jdbc.core.DataCloudResultSet;
import com.salesforce.datacloud.jdbc.core.HyperGrpcClientExecutor;
import com.salesforce.datacloud.jdbc.core.listener.AdaptiveQueryStatusListener;
import com.salesforce.datacloud.jdbc.core.listener.AsyncQueryStatusListener;
import com.salesforce.datacloud.jdbc.core.listener.QueryStatusListener;
import com.salesforce.datacloud.jdbc.exception.DataCloudJDBCException;
import com.salesforce.datacloud.jdbc.util.PropertiesExtensions;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.time.Duration;
import java.util.Properties;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import salesforce.cdp.hyperdb.v1.HyperServiceGrpc;

public class DataCloudStatement
implements Statement,
AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataCloudStatement.class);
    protected final DataCloudConnection connection;
    protected ResultSet resultSet;
    protected static final String NOT_SUPPORTED_IN_DATACLOUD_QUERY = "Write is not supported in Data Cloud query";
    protected static final String BATCH_EXECUTION_IS_NOT_SUPPORTED = "Batch execution is not supported in Data Cloud query";
    protected static final String CHANGE_FETCH_DIRECTION_IS_NOT_SUPPORTED = "Changing fetch direction is not supported";
    private static final String QUERY_TIMEOUT = "queryTimeout";
    private int queryTimeout;
    protected QueryStatusListener listener;
    private int targetMaxRows;
    private int targetMaxBytes;

    public DataCloudStatement(@NonNull DataCloudConnection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("connection is marked non-null but is null");
        }
        this.connection = connection;
        Properties properties = connection.getClientInfo();
        this.queryTimeout = PropertiesExtensions.getIntegerOrDefault(properties, QUERY_TIMEOUT, 259200);
        this.targetMaxBytes = PropertiesExtensions.getIntegerOrDefault(properties, "resultset.bytelimit", 0x1400000);
    }

    protected HyperGrpcClientExecutor getQueryExecutor() throws DataCloudJDBCException {
        Properties properties = this.connection.getClientInfo();
        HyperServiceGrpc.HyperServiceBlockingStub stub = this.connection.getChannel().getStub(properties, this.getQueryTimeoutDuration());
        return HyperGrpcClientExecutor.of(stub, properties, this.targetMaxBytes);
    }

    private void assertQueryExecuted() throws DataCloudJDBCException {
        if (this.listener == null) {
            throw new DataCloudJDBCException("a query was not executed before attempting to access results");
        }
    }

    public String getQueryId() throws DataCloudJDBCException {
        this.assertQueryExecuted();
        return this.listener.getQueryId();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        log.debug("Entering execute");
        HyperGrpcClientExecutor client = this.getQueryExecutor();
        this.resultSet = this.executeAdaptiveQuery(sql, client, this.getQueryTimeoutDuration());
        return true;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        log.debug("Entering executeQuery");
        HyperGrpcClientExecutor client = this.getQueryExecutor();
        this.resultSet = this.executeAdaptiveQuery(sql, client, this.getQueryTimeoutDuration());
        return this.resultSet;
    }

    protected DataCloudResultSet executeAdaptiveQuery(String sql, HyperGrpcClientExecutor client, Duration timeout2) throws SQLException {
        Duration queryTimeout = this.resolveQueryTimeout(timeout2);
        this.listener = this.targetMaxRows > 0 ? AdaptiveQueryStatusListener.of(sql, client, queryTimeout, this.targetMaxRows) : AdaptiveQueryStatusListener.of(sql, client, queryTimeout);
        this.resultSet = this.listener.generateResultSet();
        log.info("executeAdaptiveQuery completed. queryId={}", (Object)this.listener.getQueryId());
        return (DataCloudResultSet)this.resultSet;
    }

    public DataCloudStatement executeAsyncQuery(String sql) throws SQLException {
        log.debug("Entering executeAsyncQuery");
        HyperGrpcClientExecutor client = this.getQueryExecutor();
        return this.executeAsyncQuery(sql, client);
    }

    protected DataCloudStatement executeAsyncQuery(String sql, HyperGrpcClientExecutor client) throws SQLException {
        this.listener = AsyncQueryStatusListener.of(sql, client, this.getQueryTimeoutDuration());
        log.info("executeAsyncQuery completed. queryId={}", (Object)this.listener.getQueryId());
        return this;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        throw new DataCloudJDBCException(NOT_SUPPORTED_IN_DATACLOUD_QUERY, "0A000");
    }

    @Override
    public void close() throws SQLException {
        log.debug("Entering close");
        if (this.resultSet != null) {
            try {
                this.resultSet.close();
            }
            catch (SQLException e) {
                throw new DataCloudJDBCException(e);
            }
        }
        log.debug("Exiting close");
    }

    @Override
    public int getMaxFieldSize() {
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) {
    }

    public void clearResultSetConstraints() throws DataCloudJDBCException {
        this.setResultSetConstraints(0, 0x1400000);
    }

    private void checkResultSetConstraints(int maxRows, int maxBytes) throws DataCloudJDBCException {
        if (maxRows < 0) {
            throw new DataCloudJDBCException("setResultSetConstraints maxRows must be set to 0 to be disabled but was " + maxRows);
        }
        if (maxBytes < 1024 || maxBytes > 0x1400000) {
            throw new DataCloudJDBCException(String.format("The specified maxBytes (%d) must satisfy the following constraints: %d >= x >= %d", maxBytes, 1024, 0x1400000));
        }
    }

    public void setResultSetConstraints(int maxRows, int maxBytes) throws DataCloudJDBCException {
        this.checkResultSetConstraints(maxRows, maxBytes);
        this.targetMaxRows = maxRows;
        this.targetMaxBytes = maxBytes;
    }

    public void setResultSetConstraints(int maxRows) throws DataCloudJDBCException {
        this.setResultSetConstraints(maxRows, 0x1400000);
    }

    @Override
    public int getMaxRows() {
        return 0;
    }

    @Override
    public void setMaxRows(int max) {
    }

    @Override
    public void setEscapeProcessing(boolean enable) {
    }

    protected Duration resolveQueryTimeout(Duration timeout2) {
        if (timeout2 == null) {
            return this.getQueryTimeoutDuration();
        }
        if (timeout2.isZero() || timeout2.isNegative()) {
            return Duration.ofSeconds(259200L);
        }
        return timeout2;
    }

    protected Duration getQueryTimeoutDuration() {
        return Duration.ofSeconds(this.getQueryTimeout());
    }

    @Override
    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) {
        this.queryTimeout = seconds <= 0 ? 259200 : seconds;
    }

    @Override
    public void cancel() throws DataCloudJDBCException {
        if (this.listener == null) {
            log.warn("There was no in-progress query registered with this statement to cancel");
            return;
        }
        String queryId = this.getQueryId();
        HyperGrpcClientExecutor executor = this.getQueryExecutor();
        executor.cancel(queryId);
    }

    @Override
    public SQLWarning getWarnings() {
        return null;
    }

    @Override
    public void clearWarnings() {
    }

    @Override
    public void setCursorName(String name) {
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        log.debug("Entering getResultSet");
        this.assertQueryExecuted();
        if (this.resultSet == null) {
            this.resultSet = this.listener.generateResultSet();
        }
        log.info("getResultSet completed. queryId={}", (Object)this.listener.getQueryId());
        return this.resultSet;
    }

    @Override
    public int getUpdateCount() {
        return 0;
    }

    @Override
    public boolean getMoreResults() {
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw new DataCloudJDBCException(CHANGE_FETCH_DIRECTION_IS_NOT_SUPPORTED, "0A000");
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.assertQueryExecuted();
        return this.resultSet.getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) {
    }

    @Override
    public int getFetchSize() {
        return 0;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.assertQueryExecuted();
        return this.resultSet.getConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.assertQueryExecuted();
        return this.resultSet.getType();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new DataCloudJDBCException(BATCH_EXECUTION_IS_NOT_SUPPORTED, "0A000");
    }

    @Override
    public void clearBatch() throws SQLException {
        throw new DataCloudJDBCException(BATCH_EXECUTION_IS_NOT_SUPPORTED, "0A000");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new DataCloudJDBCException(BATCH_EXECUTION_IS_NOT_SUPPORTED, "0A000");
    }

    @Override
    public boolean getMoreResults(int current) {
        return false;
    }

    @Override
    public ResultSet getGeneratedKeys() {
        return null;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new DataCloudJDBCException(BATCH_EXECUTION_IS_NOT_SUPPORTED, "0A000");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new DataCloudJDBCException(BATCH_EXECUTION_IS_NOT_SUPPORTED, "0A000");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new DataCloudJDBCException(BATCH_EXECUTION_IS_NOT_SUPPORTED, "0A000");
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new DataCloudJDBCException(BATCH_EXECUTION_IS_NOT_SUPPORTED, "0A000");
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new DataCloudJDBCException(BATCH_EXECUTION_IS_NOT_SUPPORTED, "0A000");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new DataCloudJDBCException(BATCH_EXECUTION_IS_NOT_SUPPORTED, "0A000");
    }

    @Override
    public int getResultSetHoldability() {
        return 0;
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public void setPoolable(boolean poolable) {
    }

    @Override
    public boolean isPoolable() {
        return false;
    }

    @Override
    public void closeOnCompletion() {
    }

    @Override
    public boolean isCloseOnCompletion() {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iFace) throws SQLException {
        if (iFace.isInstance(this)) {
            return iFace.cast(this);
        }
        throw new DataCloudJDBCException("Cannot unwrap to " + iFace.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iFace) {
        return iFace.isInstance(this);
    }

    @Override
    @Generated
    public DataCloudConnection getConnection() {
        return this.connection;
    }

    @Generated
    int getTargetMaxRows() {
        return this.targetMaxRows;
    }

    @Generated
    int getTargetMaxBytes() {
        return this.targetMaxBytes;
    }
}

