/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.core;

import com.salesforce.datacloud.jdbc.config.DriverVersion;
import com.salesforce.datacloud.jdbc.interceptor.DataspaceHeaderInterceptor;
import com.salesforce.datacloud.jdbc.interceptor.HyperExternalClientContextHeaderInterceptor;
import com.salesforce.datacloud.jdbc.interceptor.HyperWorkloadHeaderInterceptor;
import com.salesforce.datacloud.jdbc.util.PropertiesExtensions;
import com.salesforce.datacloud.shaded.com.google.common.collect.ImmutableList;
import com.salesforce.datacloud.shaded.com.google.common.collect.ImmutableMap;
import com.salesforce.datacloud.shaded.io.grpc.ClientInterceptor;
import com.salesforce.datacloud.shaded.io.grpc.ManagedChannel;
import com.salesforce.datacloud.shaded.io.grpc.ManagedChannelBuilder;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import salesforce.cdp.hyperdb.v1.HyperServiceGrpc;

public class DataCloudJdbcManagedChannel
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataCloudJdbcManagedChannel.class);
    private final ManagedChannel channel;
    private static final int GRPC_INBOUND_MESSAGE_MAX_SIZE = 0x4000000;
    public static final String GRPC_KEEP_ALIVE_ENABLED = "grpc.keepAlive";
    public static final String GRPC_KEEP_ALIVE_TIME = "grpc.keepAlive.time";
    public static final String GRPC_KEEP_ALIVE_TIMEOUT = "grpc.keepAlive.timeout";
    public static final String GRPC_IDLE_TIMEOUT_SECONDS = "grpc.idleTimeoutSeconds";
    public static final String GRPC_KEEP_ALIVE_WITHOUT_CALLS = "grpc.keepAlive.withoutCalls";
    public static final String GRPC_RETRY_ENABLED = "grpc.enableRetries";
    public static final String GRPC_RETRY_POLICY_MAX_ATTEMPTS = "grpc.retryPolicy.maxAttempts";
    public static final String GRPC_RETRY_POLICY_INITIAL_BACKOFF = "grpc.retryPolicy.initialBackoff";
    public static final String GRPC_RETRY_POLICY_MAX_BACKOFF = "grpc.retryPolicy.maxBackoff";
    public static final String GRPC_RETRY_POLICY_BACKOFF_MULTIPLIER = "grpc.retryPolicy.backoffMultiplier";
    public static final String GRPC_RETRY_POLICY_RETRYABLE_STATUS_CODES = "grpc.retryPolicy.retryableStatusCodes";

    public HyperServiceGrpc.HyperServiceBlockingStub getStub(Properties properties, Duration queryTimeout) {
        ClientInterceptor[] interceptors = DataCloudJdbcManagedChannel.configurePropertyDerivedClientInterceptors(properties).toArray(new ClientInterceptor[0]);
        HyperServiceGrpc.HyperServiceBlockingStub stub = (HyperServiceGrpc.HyperServiceBlockingStub)HyperServiceGrpc.newBlockingStub(this.channel).withInterceptors(interceptors);
        if (!queryTimeout.isZero() && !queryTimeout.isNegative()) {
            log.info("Built stub with queryTimeout={}, interceptors={}", (Object)queryTimeout, (Object)interceptors.length);
            stub = (HyperServiceGrpc.HyperServiceBlockingStub)stub.withDeadlineAfter(queryTimeout.getSeconds(), TimeUnit.SECONDS);
        } else {
            log.info("Built stub with queryTimeout=none, interceptors={}", (Object)interceptors.length);
        }
        return stub;
    }

    public static DataCloudJdbcManagedChannel of(ManagedChannelBuilder<?> builder) {
        builder.maxInboundMessageSize(0x4000000);
        builder.userAgent(DriverVersion.formatDriverInfo());
        return new DataCloudJdbcManagedChannel(builder.build());
    }

    public static DataCloudJdbcManagedChannel of(ManagedChannelBuilder<?> builder, Properties properties) {
        DataCloudJdbcManagedChannel.configureKeepAlive(builder, properties);
        DataCloudJdbcManagedChannel.configureRetries(builder, properties);
        return DataCloudJdbcManagedChannel.of(builder);
    }

    private static void configureKeepAlive(ManagedChannelBuilder<?> builder, Properties properties) {
        if (PropertiesExtensions.getBooleanOrDefault(properties, GRPC_KEEP_ALIVE_ENABLED, Boolean.FALSE).booleanValue()) {
            Integer keepAliveTime = PropertiesExtensions.getIntegerOrDefault(properties, GRPC_KEEP_ALIVE_TIME, 60);
            Integer keepAliveTimeout = PropertiesExtensions.getIntegerOrDefault(properties, GRPC_KEEP_ALIVE_TIMEOUT, 10);
            Integer idleTimeoutSeconds = PropertiesExtensions.getIntegerOrDefault(properties, GRPC_IDLE_TIMEOUT_SECONDS, 300);
            Boolean keepAliveWithoutCalls = PropertiesExtensions.getBooleanOrDefault(properties, GRPC_KEEP_ALIVE_WITHOUT_CALLS, false);
            log.info("Configuring keep alive, keepAliveTimeSeconds={}, keepAliveTimeoutSeconds={}, keepAliveWithoutCalls={}, idleTimeoutSeconds={}", keepAliveTime, keepAliveTimeout, keepAliveWithoutCalls, idleTimeoutSeconds);
            ((ManagedChannelBuilder)((ManagedChannelBuilder)((ManagedChannelBuilder)builder.keepAliveTime(keepAliveTime.intValue(), TimeUnit.SECONDS)).keepAliveTimeout(keepAliveTimeout.intValue(), TimeUnit.SECONDS)).keepAliveWithoutCalls(keepAliveWithoutCalls)).idleTimeout(idleTimeoutSeconds.intValue(), TimeUnit.SECONDS);
        } else {
            log.info("Will not enable keep alive, set grpc.KeepAlive=true to enable");
        }
    }

    private static void configureRetries(ManagedChannelBuilder<?> builder, Properties properties) {
        if (PropertiesExtensions.getBooleanOrDefault(properties, GRPC_RETRY_ENABLED, Boolean.TRUE).booleanValue()) {
            Integer maxRetryAttempts = PropertiesExtensions.getIntegerOrDefault(properties, GRPC_RETRY_POLICY_MAX_ATTEMPTS, 5);
            String initialBackoff = PropertiesExtensions.optional(properties, GRPC_RETRY_POLICY_INITIAL_BACKOFF).orElse("0.5s");
            String maxBackoff = PropertiesExtensions.optional(properties, GRPC_RETRY_POLICY_MAX_BACKOFF).orElse("30s");
            String backoffMultiplier = PropertiesExtensions.optional(properties, GRPC_RETRY_POLICY_BACKOFF_MULTIPLIER).orElse("2.0");
            List<String> retryableStatusCodes = PropertiesExtensions.getListOrDefault(properties, GRPC_RETRY_POLICY_RETRYABLE_STATUS_CODES, "UNAVAILABLE");
            Map<String, Object> policy = DataCloudJdbcManagedChannel.retryPolicy(maxRetryAttempts, initialBackoff, maxBackoff, backoffMultiplier, retryableStatusCodes);
            log.info("Will enable gRPC's built in retries with: maxRetryAttempts={}, retryPolicy={}", (Object)maxRetryAttempts, (Object)policy);
            ((ManagedChannelBuilder)((ManagedChannelBuilder)builder.enableRetry()).maxRetryAttempts(maxRetryAttempts)).defaultServiceConfig(policy);
        } else {
            log.info("Will not enable gRPC's built in retries, set grpc.enableRetries=true to enable");
        }
    }

    private static Map<String, Object> retryPolicy(int maxRetryAttempts, String initialBackoff, String maxBackoff, String backoffMultiplier, List<String> retryableStatusCodes) {
        return ImmutableMap.of("methodConfig", ImmutableList.of(ImmutableMap.of("name", ImmutableList.of(Collections.EMPTY_MAP), "retryPolicy", ImmutableMap.of("maxAttempts", String.valueOf(maxRetryAttempts), "initialBackoff", initialBackoff, "maxBackoff", maxBackoff, "backoffMultiplier", backoffMultiplier, "retryableStatusCodes", retryableStatusCodes))));
    }

    @Override
    public void close() {
        if (this.channel == null || this.channel.isShutdown() || this.channel.isTerminated()) {
            return;
        }
        this.channel.shutdown();
        try {
            this.channel.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.error("Failed to shutdown channel within 5 seconds", e);
        }
        finally {
            if (!this.channel.isTerminated()) {
                this.channel.shutdownNow();
            }
        }
    }

    private static List<ClientInterceptor> configurePropertyDerivedClientInterceptors(Properties properties) {
        return Stream.of(HyperExternalClientContextHeaderInterceptor.of(properties), HyperWorkloadHeaderInterceptor.of(properties), DataspaceHeaderInterceptor.of(properties)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Generated
    private DataCloudJdbcManagedChannel(ManagedChannel channel) {
        this.channel = channel;
    }
}

