/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.core;

import com.salesforce.datacloud.jdbc.exception.DataCloudJDBCException;
import com.salesforce.datacloud.jdbc.util.StringCompatibility;
import com.salesforce.datacloud.shaded.org.apache.commons.lang3.StringUtils;
import java.net.URI;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataCloudConnectionString {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataCloudConnectionString.class);
    public static final String ILLEGAL_CONNECTION_PROTOCOL = "URL is specified with invalid datasource, expected jdbc:salesforce-datacloud";
    public static final String CONNECTION_PROTOCOL = "jdbc:salesforce-datacloud:";
    private final String databaseUrl;
    private final String loginUrl;
    private final Map<String, String> parameters;

    public static DataCloudConnectionString of(String url) throws SQLException {
        if (!DataCloudConnectionString.acceptsUrl(url)) {
            throw new DataCloudJDBCException(ILLEGAL_CONNECTION_PROTOCOL);
        }
        String database = DataCloudConnectionString.getDatabaseUrl(url);
        String login = DataCloudConnectionString.getAuthenticationUrl(url);
        Map<String, String> parameters = DataCloudConnectionString.parseParameters(url);
        return DataCloudConnectionString.builder().databaseUrl(database).loginUrl(login).parameters(parameters).build();
    }

    public static boolean acceptsUrl(String url) {
        boolean accepts = url != null && url.startsWith(CONNECTION_PROTOCOL) && DataCloudConnectionString.urlDoesNotContainScheme(url);
        log.info("acceptsUrl: accepts={}, url={}", (Object)accepts, (Object)url);
        return accepts;
    }

    private static boolean urlDoesNotContainScheme(String url) {
        String suffix = url.substring(CONNECTION_PROTOCOL.length());
        return !suffix.startsWith("http://") && !suffix.startsWith("https://");
    }

    static String getAuthenticationUrl(String url) throws SQLException {
        if (!DataCloudConnectionString.acceptsUrl(url)) {
            throw new DataCloudJDBCException(ILLEGAL_CONNECTION_PROTOCOL);
        }
        String withoutParameters = DataCloudConnectionString.withoutParameters(url);
        String serviceRootUrl = withoutParameters.substring(CONNECTION_PROTOCOL.length());
        String noTrailingSlash = StringUtils.removeEnd(serviceRootUrl, "/");
        String host = StringUtils.removeStart(noTrailingSlash, "//");
        return StringCompatibility.isBlank(host) ? host : DataCloudConnectionString.createURI(host).toString();
    }

    static String getDatabaseUrl(String url) throws SQLException {
        if (!DataCloudConnectionString.acceptsUrl(url)) {
            throw new DataCloudJDBCException(ILLEGAL_CONNECTION_PROTOCOL);
        }
        return DataCloudConnectionString.withoutParameters(url);
    }

    private static String withoutParameters(String url) {
        return url.split(";")[0];
    }

    private static Map<String, String> parseParameters(String connectionString) {
        String[] parts = connectionString.split(";");
        return Arrays.stream(parts).skip(1L).filter(pair -> pair.contains("=")).map(pair -> {
            String[] split = pair.split("=");
            return split.length != 2 ? null : split;
        }).filter(Objects::nonNull).collect(Collectors.toMap(p -> p[0], p -> p[1]));
    }

    private static URI createURI(String host) throws SQLException {
        try {
            return URI.create("https://" + host);
        }
        catch (IllegalArgumentException e) {
            throw new DataCloudJDBCException(ILLEGAL_CONNECTION_PROTOCOL, e);
        }
    }

    public void withParameters(Properties properties) {
        properties.putAll(this.parameters);
    }

    @Generated
    DataCloudConnectionString(String databaseUrl, String loginUrl, Map<String, String> parameters) {
        this.databaseUrl = databaseUrl;
        this.loginUrl = loginUrl;
        this.parameters = parameters;
    }

    @Generated
    private static DataCloudConnectionStringBuilder builder() {
        return new DataCloudConnectionStringBuilder();
    }

    @Generated
    public String getDatabaseUrl() {
        return this.databaseUrl;
    }

    @Generated
    public String getLoginUrl() {
        return this.loginUrl;
    }

    @Generated
    private static class DataCloudConnectionStringBuilder {
        @Generated
        private String databaseUrl;
        @Generated
        private String loginUrl;
        @Generated
        private Map<String, String> parameters;

        @Generated
        DataCloudConnectionStringBuilder() {
        }

        @Generated
        private DataCloudConnectionStringBuilder databaseUrl(String databaseUrl) {
            this.databaseUrl = databaseUrl;
            return this;
        }

        @Generated
        private DataCloudConnectionStringBuilder loginUrl(String loginUrl) {
            this.loginUrl = loginUrl;
            return this;
        }

        @Generated
        private DataCloudConnectionStringBuilder parameters(Map<String, String> parameters) {
            this.parameters = parameters;
            return this;
        }

        @Generated
        private DataCloudConnectionString build() {
            return new DataCloudConnectionString(this.databaseUrl, this.loginUrl, this.parameters);
        }

        @Generated
        public String toString() {
            return "DataCloudConnectionString.DataCloudConnectionStringBuilder(databaseUrl=" + this.databaseUrl + ", loginUrl=" + this.loginUrl + ", parameters=" + this.parameters + ")";
        }
    }
}

