/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.core;

import com.salesforce.datacloud.jdbc.core.DataCloudConnectionString;
import com.salesforce.datacloud.jdbc.core.DataCloudDatabaseMetadata;
import com.salesforce.datacloud.jdbc.core.DataCloudJdbcManagedChannel;
import com.salesforce.datacloud.jdbc.core.DataCloudPreparedStatement;
import com.salesforce.datacloud.jdbc.core.DataCloudResultSet;
import com.salesforce.datacloud.jdbc.core.DataCloudStatement;
import com.salesforce.datacloud.jdbc.core.DefaultParameterManager;
import com.salesforce.datacloud.jdbc.core.HyperGrpcClientExecutor;
import com.salesforce.datacloud.jdbc.core.StreamingResultSet;
import com.salesforce.datacloud.jdbc.core.partial.ChunkBased;
import com.salesforce.datacloud.jdbc.core.partial.RowBased;
import com.salesforce.datacloud.jdbc.exception.DataCloudJDBCException;
import com.salesforce.datacloud.jdbc.logging.ElapsedLogger;
import com.salesforce.datacloud.jdbc.util.ThrowingJdbcSupplier;
import com.salesforce.datacloud.query.v3.DataCloudQueryStatus;
import com.salesforce.datacloud.shaded.io.grpc.ClientInterceptor;
import com.salesforce.datacloud.shaded.io.grpc.ManagedChannelBuilder;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import salesforce.cdp.hyperdb.v1.HyperServiceGrpc;

public class DataCloudConnection
implements Connection,
AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataCloudConnection.class);
    public static final int DEFAULT_PORT = 443;
    private final DataCloudJdbcManagedChannel channel;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final ThrowingJdbcSupplier<String> lakehouseSupplier;
    private final ThrowingJdbcSupplier<List<String>> dataspacesSupplier;
    private final DataCloudConnectionString connectionString;
    private final boolean shouldCloseChannelWithConnection;
    private Properties clientInfo;

    HyperGrpcClientExecutor getExecutor() {
        HyperServiceGrpc.HyperServiceBlockingStub stub = this.channel.getStub(this.clientInfo, Duration.ofSeconds(259200L));
        return HyperGrpcClientExecutor.of(stub, this.clientInfo);
    }

    public static DataCloudConnection of(@NonNull DataCloudJdbcManagedChannel channel, @NonNull Properties properties, boolean closeChannelWithConnection) throws DataCloudJDBCException {
        if (channel == null) {
            throw new IllegalArgumentException("channel is marked non-null but is null");
        }
        if (properties == null) {
            throw new IllegalArgumentException("properties is marked non-null but is null");
        }
        return ElapsedLogger.logTimedValue(() -> DataCloudConnection.builder().channel(channel).shouldCloseChannelWithConnection(closeChannelWithConnection).clientInfo(properties).build(), "DataCloudConnection::of with provided channel. closeChannelWithConnection=" + closeChannelWithConnection, log);
    }

    public static DataCloudConnection of(@NonNull ManagedChannelBuilder<?> builder, @NonNull Properties properties) throws DataCloudJDBCException {
        if (builder == null) {
            throw new IllegalArgumentException("builder is marked non-null but is null");
        }
        if (properties == null) {
            throw new IllegalArgumentException("properties is marked non-null but is null");
        }
        return DataCloudConnection.of(DataCloudJdbcManagedChannel.of(builder, properties), properties, true);
    }

    public static DataCloudConnection of(@NonNull ManagedChannelBuilder<?> builder, @NonNull Properties properties, @NonNull ClientInterceptor authInterceptor, @NonNull ThrowingJdbcSupplier<String> lakehouseSupplier, @NonNull ThrowingJdbcSupplier<List<String>> dataspacesSupplier, @NonNull DataCloudConnectionString connectionString) throws DataCloudJDBCException {
        if (builder == null) {
            throw new IllegalArgumentException("builder is marked non-null but is null");
        }
        if (properties == null) {
            throw new IllegalArgumentException("properties is marked non-null but is null");
        }
        if (authInterceptor == null) {
            throw new IllegalArgumentException("authInterceptor is marked non-null but is null");
        }
        if (lakehouseSupplier == null) {
            throw new IllegalArgumentException("lakehouseSupplier is marked non-null but is null");
        }
        if (dataspacesSupplier == null) {
            throw new IllegalArgumentException("dataspacesSupplier is marked non-null but is null");
        }
        if (connectionString == null) {
            throw new IllegalArgumentException("connectionString is marked non-null but is null");
        }
        return ElapsedLogger.logTimedValue(() -> DataCloudConnection.builder().channel(DataCloudJdbcManagedChannel.of(builder.intercept(authInterceptor), properties)).clientInfo(properties).lakehouseSupplier(lakehouseSupplier).dataspacesSupplier(dataspacesSupplier).connectionString(connectionString).build(), "DataCloudConnection::of with oauth enabled suppliers", log);
    }

    @Override
    public Statement createStatement() {
        return this.createStatement(1003, 1007);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) {
        return this.getQueryPreparedStatement(sql);
    }

    private DataCloudPreparedStatement getQueryPreparedStatement(String sql) {
        return new DataCloudPreparedStatement(this, sql, new DefaultParameterManager());
    }

    public DataCloudResultSet getRowBasedResultSet(String queryId, long offset, long limit, RowBased.Mode mode) throws DataCloudJDBCException {
        log.info("Get row-based result set. queryId={}, offset={}, limit={}, mode={}", new Object[]{queryId, offset, limit, mode});
        HyperGrpcClientExecutor executor = this.getExecutor();
        RowBased iterator2 = RowBased.of(executor, queryId, offset, limit, mode);
        return StreamingResultSet.of(queryId, executor, iterator2);
    }

    public DataCloudResultSet getChunkBasedResultSet(String queryId, long chunkId, long limit) throws DataCloudJDBCException {
        log.info("Get chunk-based result set. queryId={}, chunkId={}, limit={}", queryId, chunkId, limit);
        HyperGrpcClientExecutor executor = this.getExecutor();
        ChunkBased iterator2 = ChunkBased.of(executor, queryId, chunkId, limit);
        return StreamingResultSet.of(queryId, executor, iterator2);
    }

    public DataCloudResultSet getChunkBasedResultSet(String queryId, long chunkId) throws DataCloudJDBCException {
        return this.getChunkBasedResultSet(queryId, chunkId, 1L);
    }

    public DataCloudQueryStatus waitForRowsAvailable(String queryId, long offset, long limit, Duration timeout2, boolean allowLessThan) throws DataCloudJDBCException {
        HyperGrpcClientExecutor executor = this.getExecutor();
        return executor.waitForRowsAvailable(queryId, offset, limit, timeout2, allowLessThan);
    }

    public DataCloudQueryStatus waitForChunksAvailable(String queryId, long offset, long limit, Duration timeout2, boolean allowLessThan) throws DataCloudJDBCException {
        HyperGrpcClientExecutor executor = this.getExecutor();
        return executor.waitForChunksAvailable(queryId, offset, limit, timeout2, allowLessThan);
    }

    public DataCloudQueryStatus waitForResultsProduced(String queryId, Duration timeout2) throws DataCloudJDBCException {
        return this.waitForQueryStatus(queryId, timeout2, DataCloudQueryStatus::allResultsProduced);
    }

    public DataCloudQueryStatus waitForQueryStatus(String queryId, Duration timeout2, Predicate<DataCloudQueryStatus> predicate) throws DataCloudJDBCException {
        HyperGrpcClientExecutor executor = this.getExecutor();
        return executor.waitForQueryStatus(queryId, timeout2, predicate);
    }

    public void cancelQuery(String queryId) throws DataCloudJDBCException {
        this.getExecutor().cancel(queryId);
    }

    public Stream<DataCloudQueryStatus> getQueryStatus(String queryId) throws DataCloudJDBCException {
        HyperGrpcClientExecutor executor = this.getExecutor();
        return executor.getQueryStatus(queryId);
    }

    @Override
    public CallableStatement prepareCall(String sql) {
        return null;
    }

    @Override
    public String nativeSQL(String sql) {
        return sql;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) {
    }

    @Override
    public boolean getAutoCommit() {
        return false;
    }

    @Override
    public void commit() {
    }

    @Override
    public void rollback() {
    }

    @Override
    public void close() {
        if (!this.shouldCloseChannelWithConnection) {
            log.debug("Called DataCloudConnection::close when shouldCloseChannelWithConnection=false");
            return;
        }
        try {
            if (this.closed.compareAndSet(false, true)) {
                this.channel.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public DatabaseMetaData getMetaData() {
        String userName = this.clientInfo.getProperty("userName");
        return new DataCloudDatabaseMetadata(this, this.connectionString, this.lakehouseSupplier, this.dataspacesSupplier, userName);
    }

    @Override
    public void setReadOnly(boolean readOnly) {
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public void setCatalog(String catalog) {
    }

    @Override
    public String getCatalog() {
        return "";
    }

    @Override
    public void setTransactionIsolation(int level) {
    }

    @Override
    public int getTransactionIsolation() {
        return 0;
    }

    @Override
    public SQLWarning getWarnings() {
        return null;
    }

    @Override
    public void clearWarnings() {
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) {
        return new DataCloudStatement(this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) {
        return this.getQueryPreparedStatement(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) {
        return null;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() {
        return null;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) {
    }

    @Override
    public void setHoldability(int holdability) {
    }

    @Override
    public int getHoldability() {
        return 0;
    }

    @Override
    public Savepoint setSavepoint() {
        return null;
    }

    @Override
    public Savepoint setSavepoint(String name) {
        return null;
    }

    @Override
    public void rollback(Savepoint savepoint) {
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) {
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        return this.getQueryPreparedStatement(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) {
        return null;
    }

    @Override
    public Clob createClob() {
        return null;
    }

    @Override
    public Blob createBlob() {
        return null;
    }

    @Override
    public NClob createNClob() {
        return null;
    }

    @Override
    public SQLXML createSQLXML() {
        return null;
    }

    @Override
    public boolean isValid(int timeout2) throws SQLException {
        if (timeout2 < 0) {
            throw new DataCloudJDBCException(String.format("Invalid timeout value: %d", timeout2));
        }
        return !this.isClosed();
    }

    @Override
    public void setClientInfo(String name, String value) {
        this.clientInfo.setProperty(name, value);
    }

    @Override
    public String getClientInfo(String name) {
        return this.clientInfo.getProperty(name);
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) {
        return null;
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) {
        return null;
    }

    @Override
    public void setSchema(String schema) {
    }

    @Override
    public String getSchema() {
        return "";
    }

    @Override
    public void abort(Executor executor) {
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) {
    }

    @Override
    public int getNetworkTimeout() {
        return 0;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!iface.isInstance(this)) {
            throw new DataCloudJDBCException(this.getClass().getName() + " not unwrappable from " + iface.getName());
        }
        return (T)this;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isInstance(this);
    }

    @Generated
    private static boolean $default$shouldCloseChannelWithConnection() {
        return true;
    }

    @Generated
    private static Properties $default$clientInfo() {
        return new Properties();
    }

    @Generated
    DataCloudConnection(DataCloudJdbcManagedChannel channel, ThrowingJdbcSupplier<String> lakehouseSupplier, ThrowingJdbcSupplier<List<String>> dataspacesSupplier, DataCloudConnectionString connectionString, boolean shouldCloseChannelWithConnection, Properties clientInfo) {
        this.channel = channel;
        this.lakehouseSupplier = lakehouseSupplier;
        this.dataspacesSupplier = dataspacesSupplier;
        this.connectionString = connectionString;
        this.shouldCloseChannelWithConnection = shouldCloseChannelWithConnection;
        this.clientInfo = clientInfo;
    }

    @Generated
    private static DataCloudConnectionBuilder builder() {
        return new DataCloudConnectionBuilder();
    }

    @Generated
    DataCloudJdbcManagedChannel getChannel() {
        return this.channel;
    }

    @Override
    @Generated
    public Properties getClientInfo() {
        return this.clientInfo;
    }

    @Override
    @Generated
    public void setClientInfo(Properties clientInfo) {
        this.clientInfo = clientInfo;
    }

    @Generated
    private static class DataCloudConnectionBuilder {
        @Generated
        private DataCloudJdbcManagedChannel channel;
        @Generated
        private ThrowingJdbcSupplier<String> lakehouseSupplier;
        @Generated
        private ThrowingJdbcSupplier<List<String>> dataspacesSupplier;
        @Generated
        private DataCloudConnectionString connectionString;
        @Generated
        private boolean shouldCloseChannelWithConnection$set;
        @Generated
        private boolean shouldCloseChannelWithConnection$value;
        @Generated
        private boolean clientInfo$set;
        @Generated
        private Properties clientInfo$value;

        @Generated
        DataCloudConnectionBuilder() {
        }

        @Generated
        private DataCloudConnectionBuilder channel(DataCloudJdbcManagedChannel channel) {
            this.channel = channel;
            return this;
        }

        @Generated
        private DataCloudConnectionBuilder lakehouseSupplier(ThrowingJdbcSupplier<String> lakehouseSupplier) {
            this.lakehouseSupplier = lakehouseSupplier;
            return this;
        }

        @Generated
        private DataCloudConnectionBuilder dataspacesSupplier(ThrowingJdbcSupplier<List<String>> dataspacesSupplier) {
            this.dataspacesSupplier = dataspacesSupplier;
            return this;
        }

        @Generated
        private DataCloudConnectionBuilder connectionString(DataCloudConnectionString connectionString) {
            this.connectionString = connectionString;
            return this;
        }

        @Generated
        private DataCloudConnectionBuilder shouldCloseChannelWithConnection(boolean shouldCloseChannelWithConnection) {
            this.shouldCloseChannelWithConnection$value = shouldCloseChannelWithConnection;
            this.shouldCloseChannelWithConnection$set = true;
            return this;
        }

        @Generated
        private DataCloudConnectionBuilder clientInfo(Properties clientInfo) {
            this.clientInfo$value = clientInfo;
            this.clientInfo$set = true;
            return this;
        }

        @Generated
        private DataCloudConnection build() {
            boolean shouldCloseChannelWithConnection$value = this.shouldCloseChannelWithConnection$value;
            if (!this.shouldCloseChannelWithConnection$set) {
                shouldCloseChannelWithConnection$value = DataCloudConnection.$default$shouldCloseChannelWithConnection();
            }
            Properties clientInfo$value = this.clientInfo$value;
            if (!this.clientInfo$set) {
                clientInfo$value = DataCloudConnection.$default$clientInfo();
            }
            return new DataCloudConnection(this.channel, this.lakehouseSupplier, this.dataspacesSupplier, this.connectionString, shouldCloseChannelWithConnection$value, clientInfo$value);
        }

        @Generated
        public String toString() {
            return "DataCloudConnection.DataCloudConnectionBuilder(channel=" + this.channel + ", lakehouseSupplier=" + this.lakehouseSupplier + ", dataspacesSupplier=" + this.dataspacesSupplier + ", connectionString=" + this.connectionString + ", shouldCloseChannelWithConnection$value=" + this.shouldCloseChannelWithConnection$value + ", clientInfo$value=" + this.clientInfo$value + ")";
        }
    }
}

