/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.core;

import com.salesforce.datacloud.jdbc.core.accessor.QueryJDBCAccessorFactory;
import com.salesforce.datacloud.jdbc.exception.DataCloudJDBCException;
import com.salesforce.datacloud.jdbc.util.ThrowingFunction;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.FieldVector;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.VectorSchemaRoot;
import com.salesforce.datacloud.shaded.org.apache.arrow.vector.ipc.ArrowStreamReader;
import com.salesforce.datacloud.shaded.org.apache.calcite.avatica.ColumnMetaData;
import com.salesforce.datacloud.shaded.org.apache.calcite.avatica.util.AbstractCursor;
import com.salesforce.datacloud.shaded.org.apache.calcite.avatica.util.ArrayImpl;
import com.salesforce.datacloud.shaded.org.apache.calcite.avatica.util.Cursor;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ArrowStreamReaderCursor
extends AbstractCursor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ArrowStreamReaderCursor.class);
    private static final int INIT_ROW_NUMBER = -1;
    private final ArrowStreamReader reader;
    private int rowsSeen = 0;
    private final AtomicInteger currentIndex = new AtomicInteger(-1);

    private void wasNullConsumer(boolean wasNull) {
        this.wasNull[0] = wasNull;
    }

    private VectorSchemaRoot getSchemaRoot() {
        return this.reader.getVectorSchemaRoot();
    }

    @Override
    public List<Cursor.Accessor> createAccessors(List<ColumnMetaData> types, Calendar localCalendar, ArrayImpl.Factory factory2) {
        return this.getSchemaRoot().getFieldVectors().stream().map(ThrowingFunction.rethrowFunction(this::createAccessor)).collect(Collectors.toList());
    }

    private Cursor.Accessor createAccessor(FieldVector vector) throws SQLException {
        return QueryJDBCAccessorFactory.createAccessor(vector, this.currentIndex::get, this::wasNullConsumer);
    }

    private boolean loadNextBatch() throws SQLException {
        try {
            if (this.reader.loadNextBatch()) {
                this.currentIndex.set(0);
                return true;
            }
        }
        catch (IOException e) {
            throw new DataCloudJDBCException(e);
        }
        return false;
    }

    @Override
    public boolean next() {
        int current = this.currentIndex.incrementAndGet();
        int total = this.getSchemaRoot().getRowCount();
        try {
            boolean next;
            boolean bl = next = current < total || this.loadNextBatch();
            if (next) {
                ++this.rowsSeen;
            }
            return next;
        }
        catch (Exception e) {
            throw new DataCloudJDBCException("Failed to load next batch", e);
        }
    }

    @Override
    protected AbstractCursor.Getter createGetter(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        this.reader.close();
    }

    @Generated
    public ArrowStreamReaderCursor(ArrowStreamReader reader) {
        this.reader = reader;
    }

    @Generated
    public int getRowsSeen() {
        return this.rowsSeen;
    }
}

