/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.auth;

import com.salesforce.datacloud.jdbc.auth.AuthenticationSettings;
import com.salesforce.datacloud.jdbc.auth.HttpCommandPath;
import com.salesforce.datacloud.jdbc.auth.OAuthToken;
import com.salesforce.datacloud.jdbc.http.FormCommand;
import lombok.Generated;
import lombok.NonNull;

class RevokeTokenAuthenticationStrategy {
    static final String REVOKE_TOKEN_KEY = "token";
    private final AuthenticationSettings settings;
    private final OAuthToken token;

    static RevokeTokenAuthenticationStrategy of(@NonNull AuthenticationSettings settings, @NonNull OAuthToken token) {
        if (settings == null) {
            throw new IllegalArgumentException("settings is marked non-null but is null");
        }
        if (token == null) {
            throw new IllegalArgumentException("token is marked non-null but is null");
        }
        return new RevokeTokenAuthenticationStrategy(settings, token);
    }

    public FormCommand toCommand() {
        FormCommand.Builder builder = FormCommand.builder();
        builder.url(this.token.getInstanceUrl());
        builder.suffix(HttpCommandPath.REVOKE.getSuffix());
        builder.header("User-Agent", this.settings.getUserAgent());
        builder.bodyEntry(REVOKE_TOKEN_KEY, this.token.getToken());
        return builder.build();
    }

    @Generated
    private RevokeTokenAuthenticationStrategy(AuthenticationSettings settings, OAuthToken token) {
        this.settings = settings;
        this.token = token;
    }

    @Generated
    public AuthenticationSettings getSettings() {
        return this.settings;
    }
}

