/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.auth;

import com.salesforce.datacloud.jdbc.exception.DataCloudJDBCException;
import com.salesforce.datacloud.shaded.com.google.common.collect.ImmutableList;
import java.net.URI;
import java.sql.SQLException;
import java.util.List;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Audience {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Audience.class);
    private static final Pattern PROD = Pattern.compile("^login\\.salesforce\\.com$");
    private static final Pattern MY_DOMAIN = Pattern.compile("^.+\\.my\\.salesforce\\.com$");
    private static final Pattern EXPERIENCE = Pattern.compile("^.+\\.my\\.site\\.com$");
    private static final Pattern SANDBOX = Pattern.compile("^test\\.salesforce\\.com$");
    private static final Pattern TEST = Pattern.compile("^login\\.test\\d+\\.pc-rnd\\.salesforce\\.com$");
    private static final Pattern MY_SANDBOX = Pattern.compile("^.+--.+\\.sandbox\\.my\\.salesforce\\.com$");
    private static final List<Pattern> PATTERNS = ImmutableList.of(PROD, MY_DOMAIN, EXPERIENCE, SANDBOX, TEST, MY_SANDBOX);

    public static String getAudience(String url) throws SQLException {
        URI uri;
        if (url == null) {
            throw new DataCloudJDBCException("Cannot determine audience for login url because it was null.");
        }
        try {
            uri = url.startsWith("https://") ? URI.create(url) : URI.create("https://" + url);
        }
        catch (IllegalArgumentException | NullPointerException ex) {
            throw new DataCloudJDBCException("The specified url was not a valid uri. url=" + url, "28000", ex);
        }
        String host = uri.getHost();
        if (PATTERNS.stream().map(Pattern::asPredicate).noneMatch(p -> p.test(host))) {
            log.warn("The specified url does not match any known hosts, but salesforce allows custom urls. host={}, url={}", (Object)host, (Object)url);
        }
        return host;
    }

    @Generated
    private Audience() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

