/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.auth;

import com.salesforce.datacloud.jdbc.auth.HttpCommandPath;
import com.salesforce.datacloud.jdbc.auth.RefreshTokenAuthenticationSettings;
import com.salesforce.datacloud.jdbc.auth.SharedAuthenticationStrategy;
import com.salesforce.datacloud.jdbc.exception.DataCloudJDBCException;
import com.salesforce.datacloud.jdbc.http.FormCommand;
import lombok.Generated;

class RefreshTokenAuthenticationStrategy
extends SharedAuthenticationStrategy {
    private static final String GRANT_TYPE = "refresh_token";
    private static final String REFRESH_TOKEN = "refresh_token";
    private final RefreshTokenAuthenticationSettings settings;

    @Override
    public FormCommand buildAuthenticate() throws DataCloudJDBCException {
        FormCommand.Builder builder = super.builder(HttpCommandPath.AUTHENTICATE);
        builder.bodyEntry("grant_type", "refresh_token");
        builder.bodyEntry("refresh_token", this.settings.getRefreshToken());
        builder.bodyEntry("client_id", this.settings.getClientId());
        builder.bodyEntry("client_secret", this.settings.getClientSecret());
        return builder.build();
    }

    @Override
    @Generated
    public RefreshTokenAuthenticationSettings getSettings() {
        return this.settings;
    }

    @Generated
    public RefreshTokenAuthenticationStrategy(RefreshTokenAuthenticationSettings settings) {
        this.settings = settings;
    }
}

