/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.datacloud.jdbc.auth;

import com.salesforce.datacloud.jdbc.auth.HttpCommandPath;
import com.salesforce.datacloud.jdbc.auth.JwtParts;
import com.salesforce.datacloud.jdbc.auth.PrivateKeyAuthenticationSettings;
import com.salesforce.datacloud.jdbc.auth.SharedAuthenticationStrategy;
import com.salesforce.datacloud.jdbc.exception.DataCloudJDBCException;
import com.salesforce.datacloud.jdbc.http.FormCommand;
import lombok.Generated;

class PrivateKeyAuthenticationStrategy
extends SharedAuthenticationStrategy {
    private static final String GRANT_TYPE = "urn:ietf:params:oauth:grant-type:jwt-bearer";
    private static final String ASSERTION = "assertion";
    private final PrivateKeyAuthenticationSettings settings;

    @Override
    public FormCommand buildAuthenticate() throws DataCloudJDBCException {
        FormCommand.Builder builder = super.builder(HttpCommandPath.AUTHENTICATE);
        builder.bodyEntry("grant_type", GRANT_TYPE);
        builder.bodyEntry(ASSERTION, JwtParts.buildJwt(this.settings));
        return builder.build();
    }

    @Override
    @Generated
    public PrivateKeyAuthenticationSettings getSettings() {
        return this.settings;
    }

    @Generated
    public PrivateKeyAuthenticationStrategy(PrivateKeyAuthenticationSettings settings) {
        this.settings = settings;
    }
}

