/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.orient.client.binary.OBinaryRequestExecutor;
import com.orientechnologies.orient.client.remote.OBinaryRequest;
import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.message.OGetRecordMetadataResponse;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.IOException;

public class OGetRecordMetadataRequest
implements OBinaryRequest<OGetRecordMetadataResponse> {
    private ORID rid;

    public OGetRecordMetadataRequest(ORID rid) {
        this.rid = rid;
    }

    public OGetRecordMetadataRequest() {
    }

    @Override
    public void write(OChannelDataOutput network, OStorageRemoteSession session) throws IOException {
        network.writeRID(this.rid);
    }

    @Override
    public void read(OChannelDataInput channel, int protocolVersion, ORecordSerializer serializer) throws IOException {
        this.rid = channel.readRID();
    }

    @Override
    public OGetRecordMetadataResponse createResponse() {
        return new OGetRecordMetadataResponse();
    }

    @Override
    public byte getCommand() {
        return 29;
    }

    @Override
    public String getDescription() {
        return "Record metadata";
    }

    public ORID getRid() {
        return this.rid;
    }

    @Override
    public OBinaryResponse execute(OBinaryRequestExecutor executor) {
        return executor.executeGetRecordMetadata(this);
    }
}

