/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.orient.client.binary.OBinaryRequestExecutor;
import com.orientechnologies.orient.client.remote.OBinaryAsyncRequest;
import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.message.ODeleteRecordResponse;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.IOException;

public class ODeleteRecordRequest
implements OBinaryAsyncRequest<ODeleteRecordResponse> {
    private ORecordId rid;
    private int version;
    private byte mode;

    public ODeleteRecordRequest(ORecordId iRid, int iVersion) {
        this.rid = iRid;
        this.version = iVersion;
    }

    public ODeleteRecordRequest() {
    }

    @Override
    public byte getCommand() {
        return 33;
    }

    @Override
    public String getDescription() {
        return "Delete Record";
    }

    @Override
    public void read(OChannelDataInput channel, int protocolVersion, ORecordSerializer serializer) throws IOException {
        this.rid = channel.readRID();
        this.version = channel.readVersion();
        this.mode = channel.readByte();
    }

    @Override
    public void write(OChannelDataOutput network, OStorageRemoteSession session) throws IOException {
        network.writeRID((ORID)this.rid);
        network.writeVersion(this.version);
        network.writeByte(this.mode);
    }

    @Override
    public byte getMode() {
        return this.mode;
    }

    public ORecordId getRid() {
        return this.rid;
    }

    public int getVersion() {
        return this.version;
    }

    @Override
    public void setMode(byte mode) {
        this.mode = mode;
    }

    @Override
    public ODeleteRecordResponse createResponse() {
        return new ODeleteRecordResponse();
    }

    @Override
    public OBinaryResponse execute(OBinaryRequestExecutor executor) {
        return executor.executeDeleteRecord(this);
    }
}

