/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message.tx;

import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ORecordOperationRequest {
    private byte type;
    private byte recordType;
    private ORID id;
    private ORID oldId;
    private byte[] record;
    private int version;
    private boolean contentChanged;

    public ORecordOperationRequest() {
    }

    public ORecordOperationRequest(byte type, byte recordType, ORID id, ORID oldId, byte[] record, int version, boolean contentChanged) {
        this.type = type;
        this.recordType = recordType;
        this.id = id;
        this.oldId = oldId;
        this.record = record;
        this.version = version;
        this.contentChanged = contentChanged;
    }

    public ORID getId() {
        return this.id;
    }

    public void setId(ORID id) {
        this.id = id;
    }

    public ORID getOldId() {
        return this.oldId;
    }

    public void setOldId(ORID oldId) {
        this.oldId = oldId;
    }

    public byte[] getRecord() {
        return this.record;
    }

    public void setRecord(byte[] record) {
        this.record = record;
    }

    public byte getRecordType() {
        return this.recordType;
    }

    public void setRecordType(byte recordType) {
        this.recordType = recordType;
    }

    public byte getType() {
        return this.type;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setContentChanged(boolean contentChanged) {
        this.contentChanged = contentChanged;
    }

    public boolean isContentChanged() {
        return this.contentChanged;
    }

    public void deserialize(DataInput input) throws IOException {
        this.type = input.readByte();
        this.recordType = input.readByte();
        this.id = ORecordId.deserialize((DataInput)input);
        this.oldId = ORecordId.deserialize((DataInput)input);
        if (this.type != 2) {
            int size = input.readInt();
            this.record = new byte[size];
            input.readFully(this.record);
        }
        this.version = input.readInt();
        this.contentChanged = input.readBoolean();
    }

    public void serialize(DataOutput output) throws IOException {
        output.writeByte(this.type);
        output.writeByte(this.recordType);
        ORecordId.serialize((ORID)this.id, (DataOutput)output);
        ORecordId.serialize((ORID)this.oldId, (DataOutput)output);
        if (this.type != 2) {
            output.writeInt(this.record.length);
            output.write(this.record);
        }
        output.writeInt(this.version);
        output.writeBoolean(this.contentChanged);
    }
}

