/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message.sequence;

import com.orientechnologies.orient.core.metadata.sequence.OSequence;
import com.orientechnologies.orient.core.metadata.sequence.OSequenceAction;
import com.orientechnologies.orient.core.metadata.sequence.SequenceOrderType;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class OSequenceActionRequest {
    private OSequenceAction action = null;

    public OSequenceActionRequest() {
    }

    public OSequenceActionRequest(OSequenceAction action) {
        this.action = action;
    }

    private void serializeInt(Integer val, DataOutput out) throws IOException {
        if (val != null) {
            out.writeByte(1);
            out.writeInt(val);
        } else {
            out.writeByte(0);
        }
    }

    private Integer deserializeInt(DataInput in) throws IOException {
        Integer retval = null;
        byte nullVal = in.readByte();
        if (nullVal > 0) {
            retval = in.readInt();
        }
        return retval;
    }

    private void serializeLong(Long val, DataOutput out) throws IOException {
        if (val != null) {
            out.writeByte(1);
            out.writeLong(val);
        } else {
            out.writeByte(0);
        }
    }

    private Long deserializeLong(DataInput in) throws IOException {
        Long retval = null;
        byte nullVal = in.readByte();
        if (nullVal > 0) {
            retval = in.readLong();
        }
        return retval;
    }

    private void serializeOrderType(SequenceOrderType val, DataOutput out) throws IOException {
        if (val != null) {
            out.writeByte(1);
            out.writeByte(val.getValue());
        } else {
            out.writeByte(0);
        }
    }

    private SequenceOrderType deserializeOrderType(DataInput in) throws IOException {
        SequenceOrderType retval = null;
        byte nullVal = in.readByte();
        if (nullVal > 0) {
            retval = SequenceOrderType.fromValue((byte)in.readByte());
        }
        return retval;
    }

    private void serializeBoolean(Boolean val, DataOutput out) throws IOException {
        if (val != null) {
            out.writeByte(1);
            out.writeBoolean(val);
        } else {
            out.writeByte(0);
        }
    }

    private Boolean deserializeBoolean(DataInput in) throws IOException {
        Boolean retval = null;
        byte nullVal = in.readByte();
        if (nullVal > 0) {
            retval = in.readBoolean();
        }
        return retval;
    }

    public void serialize(DataOutput out) throws IOException {
        if (this.action != null) {
            out.writeInt(this.action.getActionType());
            byte[] sequenceNameBytes = this.action.getSequenceName().getBytes(StandardCharsets.UTF_8.name());
            out.writeInt(sequenceNameBytes.length);
            out.write(sequenceNameBytes);
            this.serializeLong(this.action.getCurrentValue(), out);
            out.writeByte(this.action.getSequenceType().getVal());
            OSequence.CreateParams params = this.action.getParameters();
            if (params == null) {
                out.writeByte(0);
            } else {
                out.writeByte(1);
                this.serializeLong(params.getStart(), out);
                this.serializeInt(params.getIncrement(), out);
                this.serializeInt(params.getCacheSize(), out);
                this.serializeLong(params.getLimitValue(), out);
                this.serializeOrderType(params.getOrderType(), out);
                this.serializeBoolean(params.getRecyclable(), out);
                this.serializeBoolean(params.getTurnLimitOff(), out);
                this.serializeLong(params.getCurrentValue(), out);
            }
        } else {
            out.writeInt(-1);
        }
    }

    public void deserialize(DataInput in) throws IOException {
        int actionType = in.readInt();
        if (actionType > 0) {
            int nameLength = in.readInt();
            byte[] nameBytes = new byte[nameLength];
            in.readFully(nameBytes);
            String sequenceName = new String(nameBytes, StandardCharsets.UTF_8.name());
            Long currentValue = this.deserializeLong(in);
            byte sequenceTypeByte = in.readByte();
            OSequence.SEQUENCE_TYPE sequenceType = OSequence.SEQUENCE_TYPE.fromVal((byte)sequenceTypeByte);
            if (sequenceType == null) {
                throw new IOException("Inavlid sequnce type value: " + sequenceTypeByte);
            }
            OSequence.CreateParams params = null;
            byte paramsNullFlag = in.readByte();
            if (paramsNullFlag > 0) {
                params = new OSequence.CreateParams();
                params.resetNull();
                params.setStart(this.deserializeLong(in));
                params.setIncrement(this.deserializeInt(in));
                params.setCacheSize(this.deserializeInt(in));
                params.setLimitValue(this.deserializeLong(in));
                params.setOrderType(this.deserializeOrderType(in));
                params.setRecyclable(this.deserializeBoolean(in).booleanValue());
                params.setTurnLimitOff(this.deserializeBoolean(in));
                params.setCurrentValue(this.deserializeLong(in));
            }
            this.action = currentValue != null ? new OSequenceAction(sequenceName, currentValue.longValue()) : new OSequenceAction(actionType, sequenceName, params, sequenceType);
        } else {
            this.action = null;
        }
    }

    public OSequenceAction getAction() {
        return this.action;
    }
}

