/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.orient.client.binary.OBinaryRequestExecutor;
import com.orientechnologies.orient.client.remote.OBinaryRequest;
import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.OCollectionNetworkSerializer;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.message.OSBTGetResponse;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OBonsaiCollectionPointer;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.IOException;

public class OSBTGetRequest
implements OBinaryRequest<OSBTGetResponse> {
    private OBonsaiCollectionPointer collectionPointer;
    private byte[] keyStream;

    public OSBTGetRequest(OBonsaiCollectionPointer collectionPointer, byte[] keyStream) {
        this.collectionPointer = collectionPointer;
        this.keyStream = keyStream;
    }

    public OSBTGetRequest() {
    }

    @Override
    public void write(OChannelDataOutput network, OStorageRemoteSession session) throws IOException {
        OCollectionNetworkSerializer.INSTANCE.writeCollectionPointer(network, this.collectionPointer);
        network.writeBytes(this.keyStream);
    }

    @Override
    public void read(OChannelDataInput channel, int protocolVersion, ORecordSerializer serializer) throws IOException {
        this.collectionPointer = OCollectionNetworkSerializer.INSTANCE.readCollectionPointer(channel);
        this.keyStream = channel.readBytes();
    }

    @Override
    public byte getCommand() {
        return 111;
    }

    @Override
    public String getDescription() {
        return "SB-Tree bonsai get";
    }

    public OBonsaiCollectionPointer getCollectionPointer() {
        return this.collectionPointer;
    }

    public byte[] getKeyStream() {
        return this.keyStream;
    }

    @Override
    public OSBTGetResponse createResponse() {
        return new OSBTGetResponse();
    }

    @Override
    public OBinaryResponse execute(OBinaryRequestExecutor executor) {
        return executor.executeSBTGet(this);
    }
}

