/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.orient.client.binary.OBinaryRequestExecutor;
import com.orientechnologies.orient.client.remote.OBinaryRequest;
import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.OCollectionNetworkSerializer;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.message.OSBTFirstKeyResponse;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OBonsaiCollectionPointer;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.IOException;

public class OSBTFirstKeyRequest
implements OBinaryRequest<OSBTFirstKeyResponse> {
    private OBonsaiCollectionPointer collectionPointer;

    public OSBTFirstKeyRequest(OBonsaiCollectionPointer collectionPointer) {
        this.collectionPointer = collectionPointer;
    }

    public OSBTFirstKeyRequest() {
    }

    @Override
    public void write(OChannelDataOutput network, OStorageRemoteSession session) throws IOException {
        OCollectionNetworkSerializer.INSTANCE.writeCollectionPointer(network, this.collectionPointer);
    }

    @Override
    public void read(OChannelDataInput channel, int protocolVersion, ORecordSerializer serializer) throws IOException {
        this.collectionPointer = OCollectionNetworkSerializer.INSTANCE.readCollectionPointer(channel);
    }

    @Override
    public byte getCommand() {
        return 112;
    }

    @Override
    public String getDescription() {
        return "SB-Tree bonsai get first key";
    }

    public OBonsaiCollectionPointer getCollectionPointer() {
        return this.collectionPointer;
    }

    @Override
    public OSBTFirstKeyResponse createResponse() {
        return new OSBTFirstKeyResponse();
    }

    @Override
    public OBinaryResponse execute(OBinaryRequestExecutor executor) {
        return executor.executeSBTFirstKey(this);
    }
}

