/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.orient.client.binary.OBinaryRequestExecutor;
import com.orientechnologies.orient.client.remote.OBinaryRequest;
import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.message.OReadRecordIfVersionIsNotLatestResponse;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.IOException;

public class OReadRecordIfVersionIsNotLatestRequest
implements OBinaryRequest<OReadRecordIfVersionIsNotLatestResponse> {
    private ORecordId rid;
    private int recordVersion;
    private String fetchPlan;
    private boolean ignoreCache;

    public OReadRecordIfVersionIsNotLatestRequest(ORecordId rid, int recordVersion, String fetchPlan, boolean ignoreCache) {
        this.rid = rid;
        this.recordVersion = recordVersion;
        this.fetchPlan = fetchPlan;
        this.ignoreCache = ignoreCache;
    }

    public OReadRecordIfVersionIsNotLatestRequest() {
    }

    @Override
    public void write(OChannelDataOutput network, OStorageRemoteSession session) throws IOException {
        network.writeRID((ORID)this.rid);
        network.writeVersion(this.recordVersion);
        network.writeString(this.fetchPlan != null ? this.fetchPlan : "");
        network.writeByte((byte)(this.ignoreCache ? 1 : 0));
    }

    @Override
    public void read(OChannelDataInput channel, int protocolVersion, ORecordSerializer serializer) throws IOException {
        this.rid = channel.readRID();
        this.recordVersion = channel.readVersion();
        this.fetchPlan = channel.readString();
        this.ignoreCache = channel.readByte() != 0;
    }

    @Override
    public byte getCommand() {
        return 44;
    }

    @Override
    public String getDescription() {
        return "Load record if version is not latest";
    }

    public ORecordId getRid() {
        return this.rid;
    }

    public int getRecordVersion() {
        return this.recordVersion;
    }

    public String getFetchPlan() {
        return this.fetchPlan;
    }

    public boolean isIgnoreCache() {
        return this.ignoreCache;
    }

    @Override
    public OReadRecordIfVersionIsNotLatestResponse createResponse() {
        return new OReadRecordIfVersionIsNotLatestResponse();
    }

    @Override
    public OBinaryResponse execute(OBinaryRequestExecutor executor) {
        return executor.executeReadRecordIfNotLastest(this);
    }
}

