/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.orient.client.binary.OBinaryRequestExecutor;
import com.orientechnologies.orient.client.remote.OBinaryRequest;
import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.message.OQueryResponse;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.IOException;

public final class OQueryNextPageRequest
implements OBinaryRequest<OQueryResponse> {
    private String queryId;
    private int recordsPerPage;

    public OQueryNextPageRequest(String queryId, int recordsPerPage) {
        this.queryId = queryId;
        this.recordsPerPage = recordsPerPage;
    }

    public OQueryNextPageRequest() {
    }

    @Override
    public void write(OChannelDataOutput network, OStorageRemoteSession session) throws IOException {
        network.writeString(this.queryId);
        network.writeInt(this.recordsPerPage);
    }

    @Override
    public void read(OChannelDataInput channel, int protocolVersion, ORecordSerializer serializer) throws IOException {
        this.queryId = channel.readString();
        this.recordsPerPage = channel.readInt();
    }

    @Override
    public byte getCommand() {
        return 47;
    }

    @Override
    public String getDescription() {
        return "Execute remote query";
    }

    @Override
    public OQueryResponse createResponse() {
        return new OQueryResponse();
    }

    @Override
    public OBinaryResponse execute(OBinaryRequestExecutor executor) {
        return executor.executeQueryNextPage(this);
    }

    public String getQueryId() {
        return this.queryId;
    }

    public void setQueryId(String queryId) {
        this.queryId = queryId;
    }

    public int getRecordsPerPage() {
        return this.recordsPerPage;
    }
}

