/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.common.exception.OErrorCode;
import com.orientechnologies.orient.client.remote.ORemotePushHandler;
import com.orientechnologies.orient.client.remote.message.OBinaryPushRequest;
import com.orientechnologies.orient.client.remote.message.OBinaryPushResponse;
import com.orientechnologies.orient.client.remote.message.OMessageHelper;
import com.orientechnologies.orient.client.remote.message.live.OLiveQueryResult;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializerNetworkV37;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class OLiveQueryPushRequest
implements OBinaryPushRequest {
    public static final byte HAS_MORE = 1;
    public static final byte END = 2;
    public static final byte ERROR = 3;
    private int monitorId;
    private byte status;
    private int errorIdentifier;
    private OErrorCode errorCode;
    private String errorMessage;
    private List<OLiveQueryResult> events;

    public OLiveQueryPushRequest(int monitorId, int errorIdentifier, OErrorCode errorCode, String errorMessage) {
        this.monitorId = monitorId;
        this.status = (byte)3;
        this.errorIdentifier = errorIdentifier;
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    public OLiveQueryPushRequest(int monitorId, byte status, List<OLiveQueryResult> events) {
        this.monitorId = monitorId;
        this.status = status;
        this.events = events;
    }

    public OLiveQueryPushRequest() {
    }

    @Override
    public void write(OChannelDataOutput channel) throws IOException {
        channel.writeInt(this.monitorId);
        channel.writeByte(this.status);
        if (this.status == 3) {
            channel.writeInt(this.errorIdentifier);
            channel.writeInt(this.errorCode.getCode());
            channel.writeString(this.errorMessage);
        } else {
            channel.writeInt(this.events.size());
            for (OLiveQueryResult event : this.events) {
                channel.writeByte(event.getEventType());
                OMessageHelper.writeResult(event.getCurrentValue(), channel, (ORecordSerializer)ORecordSerializerNetworkV37.INSTANCE);
                if (event.getEventType() != 2) continue;
                OMessageHelper.writeResult(event.getOldValue(), channel, (ORecordSerializer)ORecordSerializerNetworkV37.INSTANCE);
            }
        }
    }

    @Override
    public void read(OChannelDataInput network) throws IOException {
        this.monitorId = network.readInt();
        this.status = network.readByte();
        if (this.status == 3) {
            this.errorIdentifier = network.readInt();
            this.errorCode = OErrorCode.getErrorCode((int)network.readInt());
            this.errorMessage = network.readString();
        } else {
            int eventSize = network.readInt();
            this.events = new ArrayList<OLiveQueryResult>(eventSize);
            while (eventSize-- > 0) {
                byte type = network.readByte();
                OResultInternal currentValue = OMessageHelper.readResult(network);
                OResultInternal oldValue = null;
                if (type == 2) {
                    oldValue = OMessageHelper.readResult(network);
                }
                this.events.add(new OLiveQueryResult(type, (OResult)currentValue, (OResult)oldValue));
            }
        }
    }

    public OBinaryPushResponse execute(ORemotePushHandler remote) {
        remote.executeLiveQueryPush(this);
        return null;
    }

    @Override
    public OBinaryPushResponse createResponse() {
        return null;
    }

    @Override
    public byte getPushCommand() {
        return 81;
    }

    public int getMonitorId() {
        return this.monitorId;
    }

    public List<OLiveQueryResult> getEvents() {
        return this.events;
    }

    public byte getStatus() {
        return this.status;
    }

    public void setStatus(byte status) {
        this.status = status;
    }

    public int getErrorIdentifier() {
        return this.errorIdentifier;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public OErrorCode getErrorCode() {
        return this.errorCode;
    }
}

