/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.orient.client.binary.OBinaryRequestExecutor;
import com.orientechnologies.orient.client.remote.OBinaryRequest;
import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.message.OImportResponse;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class OImportRequest
implements OBinaryRequest<OImportResponse> {
    private InputStream inputStream;
    private String options;
    private String name;
    private String imporPath;

    public OImportRequest(InputStream inputStream, String options, String name) {
        this.inputStream = inputStream;
        this.options = options;
        this.name = name;
    }

    public OImportRequest() {
    }

    @Override
    public void write(OChannelDataOutput network, OStorageRemoteSession session) throws IOException {
        int size;
        network.writeString(this.options);
        network.writeString(this.name);
        byte[] buffer = new byte[1024];
        while ((size = this.inputStream.read(buffer)) > 0) {
            network.writeBytes(buffer, size);
        }
        network.writeBytes(null);
    }

    @Override
    public void read(OChannelDataInput channel, int protocolVersion, ORecordSerializer serializer) throws IOException {
        byte[] bytes;
        this.options = channel.readString();
        this.name = channel.readString();
        File file = File.createTempFile("import", this.name);
        FileOutputStream output = new FileOutputStream(file);
        while ((bytes = channel.readBytes()) != null) {
            output.write(bytes);
        }
        output.close();
        this.imporPath = file.getAbsolutePath();
    }

    @Override
    public byte getCommand() {
        return 98;
    }

    @Override
    public String getDescription() {
        return "Import Database";
    }

    public String getImporPath() {
        return this.imporPath;
    }

    public String getName() {
        return this.name;
    }

    public String getOptions() {
        return this.options;
    }

    @Override
    public OImportResponse createResponse() {
        return new OImportResponse();
    }

    @Override
    public OBinaryResponse execute(OBinaryRequestExecutor executor) {
        return executor.executeImport(this);
    }
}

