/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.orient.client.binary.OBinaryRequestExecutor;
import com.orientechnologies.orient.client.remote.OBinaryRequest;
import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.message.OHigherPhysicalPositionsResponse;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.IOException;

public class OHigherPhysicalPositionsRequest
implements OBinaryRequest<OHigherPhysicalPositionsResponse> {
    private int clusterId;
    private OPhysicalPosition clusterPosition;

    public OHigherPhysicalPositionsRequest(int iClusterId, OPhysicalPosition iClusterPosition) {
        this.clusterId = iClusterId;
        this.clusterPosition = iClusterPosition;
    }

    public OHigherPhysicalPositionsRequest() {
    }

    @Override
    public void write(OChannelDataOutput network, OStorageRemoteSession session) throws IOException {
        network.writeInt(this.clusterId);
        network.writeLong(this.clusterPosition.clusterPosition);
    }

    @Override
    public void read(OChannelDataInput channel, int protocolVersion, ORecordSerializer serializer) throws IOException {
        this.clusterId = channel.readInt();
        this.clusterPosition = new OPhysicalPosition(channel.readLong());
    }

    @Override
    public byte getCommand() {
        return 36;
    }

    @Override
    public String getDescription() {
        return "Retrieve higher positions";
    }

    public int getClusterId() {
        return this.clusterId;
    }

    public OPhysicalPosition getClusterPosition() {
        return this.clusterPosition;
    }

    @Override
    public OHigherPhysicalPositionsResponse createResponse() {
        return new OHigherPhysicalPositionsResponse();
    }

    @Override
    public OBinaryResponse execute(OBinaryRequestExecutor executor) {
        return executor.executeHigherPosition(this);
    }
}

