/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.orient.client.binary.OBinaryRequestExecutor;
import com.orientechnologies.orient.client.remote.OBinaryRequest;
import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.message.OCountResponse;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.IOException;

public final class OCountRequest
implements OBinaryRequest<OCountResponse> {
    private int[] clusterIds;
    private boolean countTombstones;

    public OCountRequest(int[] iClusterIds, boolean countTombstones) {
        this.clusterIds = iClusterIds;
        this.countTombstones = countTombstones;
    }

    public OCountRequest() {
    }

    @Override
    public void write(OChannelDataOutput network, OStorageRemoteSession session) throws IOException {
        network.writeShort((short)this.clusterIds.length);
        for (int iClusterId : this.clusterIds) {
            network.writeShort((short)iClusterId);
        }
        network.writeByte(this.countTombstones ? (byte)1 : 0);
    }

    @Override
    public void read(OChannelDataInput channel, int protocolVersion, ORecordSerializer serializer) throws IOException {
        short nclusters = channel.readShort();
        this.clusterIds = new int[nclusters];
        for (int i = 0; i < this.clusterIds.length; ++i) {
            this.clusterIds[i] = channel.readShort();
        }
        this.countTombstones = channel.readByte() != 0;
    }

    @Override
    public byte getCommand() {
        return 12;
    }

    @Override
    public String getDescription() {
        return "Count cluster elements";
    }

    public int[] getClusterIds() {
        return this.clusterIds;
    }

    public boolean isCountTombstones() {
        return this.countTombstones;
    }

    @Override
    public OCountResponse createResponse() {
        return new OCountResponse();
    }

    @Override
    public OBinaryResponse execute(OBinaryRequestExecutor executor) {
        return executor.executeCountCluster(this);
    }
}

